#
# (C) Tenable Network Security
#


if (description)
{
  script_id(23733);
  script_version ("$Revision: 1.5 $");

  script_cve_id("CVE-2006-6237");
  script_xref(name:"OSVDB", value:"30681");

  script_name(english:"Burning Board decode_cookie() SQL Injection Vulnerability");
  script_summary(english:"Checks for SQL injection vulnerability in Burning Board Lite");
 
  desc = "
Synopsis : 

The remote web server contains a PHP script that is affected by a SQL
injection vulnerability. 

Description :

The remote version of Burning Board Lite fails to sanitize user-
supplied cookie input before using it in the 'decode_cookie()'
function in a database query.  Regardless of PHP settings, an
unauthenticated attacker may be able to leverage this issue to uncover
sensitive information (such as password hashes), modify existing data,
or launch attacks against the underlying database. 

See also : 

http://retrogod.altervista.org/wbblite_102_sql_mqg_bypass.html
http://milw0rm.com/exploits/2841

Solution : 

Unknown at this time.

Risk factor : 

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2006-2008 Tenable Network Security");

  script_dependencies("burning_board_detect.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Test any installs.
install = get_kb_list(string("www/", port, "/burning_board_lite"));
if (isnull(install)) exit(0);
matches = eregmatch(string:install, pattern:"^(.+) under (/.*)$");
if (!isnull(matches))
{
  dir = matches[2];

  # First we need a thread id.
  res = http_get_cache(item:string(dir, "/index.php"), port:port);
  if (res == NULL) exit(0);

  pat = '<a href="thread\\.php\\?.*threadid=([0-9]+)';
  matches = egrep(pattern:pat, string:res);
  tid = NULL;
  if (matches) 
  {
    foreach match (split(matches)) 
    {
      match = chomp(match);
      thread = eregmatch(pattern:pat, string:match);
      if (!isnull(thread)) {
        tid = thread[1];
        break;
      }
    }
  }

  # If we have a thread id.
  if (isnull(tid))
  {
    if (log_verbosity > 1) debug_print("couldn't find a thread id to use!", level:0);
  }
  else 
  {
    # Try to exploit the flaw to generate a SQL error.
    postdata = "goto=firstnew";
    req = string(
      "POST ", dir, "/thread.php?threadid=", tid, " HTTP/1.1\r\n",
      "Host: ", get_host_name(), "\r\n",
      "User-Agent: ", get_kb_item("global_settings/http_user_agent"), "\r\n",
      "Cookie: threadvisit=1,999999999999999'", SCRIPT_NAME, "\r\n",
      "Content-Type: application/x-www-form-urlencoded\r\n",
      "Content-Length: ", strlen(postdata), "\r\n",
      "\r\n",
      postdata
    );
    res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
    if (res == NULL) exit(0);

    # There's a problem if we see a database error with our script name.
    if (
      "SQL-DATABASE ERROR" >< res &&
      string("posttime>'999999999999999'", SCRIPT_NAME) >< res
    ) security_hole(port);
  }
}
