#
# (C) Tenable Network Security
#

if(description)
{
 script_id(25766);
 script_version("$Revision: 1.4 $");

 script_cve_id("CVE-2007-0060");
 script_bugtraq_id(25051);
 script_xref(name:"OSVDB", value:"38598");

 name["english"] = "Computer Associates Multiple Products Message Queuing Remote Stack Buffer Overflow Vulnerability";

 script_name(english:name["english"]);

 desc["english"] = "
Synopsis :

Arbitrary code can be executed on the remote host due to a flaw in the
CAM service. 

Description :

The remote version of Computer Associates Message Queuing Service
contains a a stack overflow that may allow an attacker to execute
arbitrary code on the remote host with SYSTEM privileges. 

An attacker does not need to be authenticated to exploit this flaw. 

See also :

http://www.ca.com/us/securityadvisor/newsinfo/collateral.aspx?cid=149809

Solution :

Computer Associates has released a set of patches for CAM 1.11. 

Risk factor : 

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";

 script_description(english:desc["english"]);

 summary["english"] = "Determines if the remote CAM service is vulnerable to a buffer overflow";

 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc");
 family["english"] = "Gain root remotely";
 script_family(english:family["english"]);

 script_dependencies("cacam_detect.nasl", "os_fingerprint.nasl");
 script_require_keys("CA/MessageQueuing", "Host/OS");
 script_require_ports(4105);
 exit(0);
}


# Only Windows and Netware are affected per CA's advisory.
os = get_kb_item("Host/OS");
if (!os || ("Windows" >!< os && "Novell Netware" >!< os)) exit(0);


version = get_kb_item ("CA/MessageQueuing");
if (isnull(version))
  exit (0);

port = 4105;

main = ereg_replace (pattern:"^([0-9]+)\.[0-9]+ \(Build [0-9]+_[0-9]+\)$", string:version, replace:"\1");
revision = ereg_replace (pattern:"^[0-9]+\.([0-9]+) \(Build [0-9]+_[0-9]+\)$", string:version, replace:"\1");

build = ereg_replace (pattern:"^[0-9]+\.[0-9]+ \(Build ([0-9]+)_[0-9]+\)$", string:version, replace:"\1");
build_rev = ereg_replace (pattern:"^[0-9]+\.[0-9]+ \(Build [0-9]+_([0-9]+)\)$", string:version, replace:"\1");


main = int(main);
revision = int (revision);
build = int(build);
build_rev = int (build_rev);


# vulnerable :
# < 1.10
# < 1.10 build 54_4
# < 1.11 build 54_4

if ( (main < 1) ||
     (main == 1 && revision < 10) ||
     (main == 1 && revision == 10 && build < 54) ||
     (main == 1 && revision == 10 && build == 54 && build_rev < 4) ||
     (main == 1 && revision == 11 && build < 54) ||
     (main == 1 && revision == 11 && build == 54 && build_rev < 4) )
{
 security_hole(port);
}

