#
# (C) Tenable Network Security, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);
desc = "
Synopsis :

The remote host is missing a security update.

Description :

The remote CentOS system is missing a security update which has been 
documented in Red Hat advisory RHSA-2007-0327.

See also :

https://rhn.redhat.com/errata/RHSA-2007-0327.html

Solution :

Upgrade to the newest packages by doing :

  yum update

Risk factor :

High";

if ( description )
{
 script_id(25223);
 script_version("$Revision: 1.2 $");
 script_name(english:"CentOS : RHSA-2007-0327");
 script_description(english:desc);

 script_summary(english:"Checks for missing updates on the remote CentOS system");
 script_category(ACT_GATHER_INFO);
 script_copyright(english:"This script is (C) 2007 Tenable Network Security, Inc.");
 script_family(english:"CentOS Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/CentOS/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check(reference:"jakarta-commons-modeler-1.1-8jpp.1.0.2.el5", release:"CentOS-5", cpu:"i386") )  faulty += '- jakarta-commons-modeler-1.1-8jpp.1.0.2.el5\n';
if ( rpm_check(reference:"jakarta-commons-modeler-javadoc-1.1-8jpp.1.0.2.el5", release:"CentOS-5", cpu:"i386") )  faulty += '- jakarta-commons-modeler-javadoc-1.1-8jpp.1.0.2.el5\n';
if ( rpm_check(reference:"tomcat5-5.5.23-0jpp.1.0.3.el5", release:"CentOS-5", cpu:"i386") )  faulty += '- tomcat5-5.5.23-0jpp.1.0.3.el5\n';
if ( rpm_check(reference:"tomcat5-admin-webapps-5.5.23-0jpp.1.0.3.el5", release:"CentOS-5", cpu:"i386") )  faulty += '- tomcat5-admin-webapps-5.5.23-0jpp.1.0.3.el5\n';
if ( rpm_check(reference:"tomcat5-common-lib-5.5.23-0jpp.1.0.3.el5", release:"CentOS-5", cpu:"i386") )  faulty += '- tomcat5-common-lib-5.5.23-0jpp.1.0.3.el5\n';
if ( rpm_check(reference:"tomcat5-jasper-5.5.23-0jpp.1.0.3.el5", release:"CentOS-5", cpu:"i386") )  faulty += '- tomcat5-jasper-5.5.23-0jpp.1.0.3.el5\n';
if ( rpm_check(reference:"tomcat5-jasper-javadoc-5.5.23-0jpp.1.0.3.el5", release:"CentOS-5", cpu:"i386") )  faulty += '- tomcat5-jasper-javadoc-5.5.23-0jpp.1.0.3.el5\n';
if ( rpm_check(reference:"tomcat5-jsp-2.0-api-5.5.23-0jpp.1.0.3.el5", release:"CentOS-5", cpu:"i386") )  faulty += '- tomcat5-jsp-2.0-api-5.5.23-0jpp.1.0.3.el5\n';
if ( rpm_check(reference:"tomcat5-jsp-2.0-api-javadoc-5.5.23-0jpp.1.0.3.el5", release:"CentOS-5", cpu:"i386") )  faulty += '- tomcat5-jsp-2.0-api-javadoc-5.5.23-0jpp.1.0.3.el5\n';
if ( rpm_check(reference:"tomcat5-server-lib-5.5.23-0jpp.1.0.3.el5", release:"CentOS-5", cpu:"i386") )  faulty += '- tomcat5-server-lib-5.5.23-0jpp.1.0.3.el5\n';
if ( rpm_check(reference:"tomcat5-servlet-2.4-api-5.5.23-0jpp.1.0.3.el5", release:"CentOS-5", cpu:"i386") )  faulty += '- tomcat5-servlet-2.4-api-5.5.23-0jpp.1.0.3.el5\n';
if ( rpm_check(reference:"tomcat5-servlet-2.4-api-javadoc-5.5.23-0jpp.1.0.3.el5", release:"CentOS-5", cpu:"i386") )  faulty += '- tomcat5-servlet-2.4-api-javadoc-5.5.23-0jpp.1.0.3.el5\n';
if ( rpm_check(reference:"tomcat5-webapps-5.5.23-0jpp.1.0.3.el5", release:"CentOS-5", cpu:"i386") )  faulty += '- tomcat5-webapps-5.5.23-0jpp.1.0.3.el5\n';
if ( rpm_check(reference:"jakarta-commons-modeler-1.1-8jpp.1.0.2.el5", release:"CentOS-5", cpu:"x86_64") )  faulty += '- jakarta-commons-modeler-1.1-8jpp.1.0.2.el5\n';
if ( rpm_check(reference:"jakarta-commons-modeler-javadoc-1.1-8jpp.1.0.2.el5", release:"CentOS-5", cpu:"x86_64") )  faulty += '- jakarta-commons-modeler-javadoc-1.1-8jpp.1.0.2.el5\n';
if ( rpm_check(reference:"tomcat5-5.5.23-0jpp.1.0.3.el5", release:"CentOS-5", cpu:"x86_64") )  faulty += '- tomcat5-5.5.23-0jpp.1.0.3.el5\n';
if ( rpm_check(reference:"tomcat5-admin-webapps-5.5.23-0jpp.1.0.3.el5", release:"CentOS-5", cpu:"x86_64") )  faulty += '- tomcat5-admin-webapps-5.5.23-0jpp.1.0.3.el5\n';
if ( rpm_check(reference:"tomcat5-common-lib-5.5.23-0jpp.1.0.3.el5", release:"CentOS-5", cpu:"x86_64") )  faulty += '- tomcat5-common-lib-5.5.23-0jpp.1.0.3.el5\n';
if ( rpm_check(reference:"tomcat5-jasper-5.5.23-0jpp.1.0.3.el5", release:"CentOS-5", cpu:"x86_64") )  faulty += '- tomcat5-jasper-5.5.23-0jpp.1.0.3.el5\n';
if ( rpm_check(reference:"tomcat5-jasper-javadoc-5.5.23-0jpp.1.0.3.el5", release:"CentOS-5", cpu:"x86_64") )  faulty += '- tomcat5-jasper-javadoc-5.5.23-0jpp.1.0.3.el5\n';
if ( rpm_check(reference:"tomcat5-jsp-2.0-api-5.5.23-0jpp.1.0.3.el5", release:"CentOS-5", cpu:"x86_64") )  faulty += '- tomcat5-jsp-2.0-api-5.5.23-0jpp.1.0.3.el5\n';
if ( rpm_check(reference:"tomcat5-jsp-2.0-api-javadoc-5.5.23-0jpp.1.0.3.el5", release:"CentOS-5", cpu:"x86_64") )  faulty += '- tomcat5-jsp-2.0-api-javadoc-5.5.23-0jpp.1.0.3.el5\n';
if ( rpm_check(reference:"tomcat5-server-lib-5.5.23-0jpp.1.0.3.el5", release:"CentOS-5", cpu:"x86_64") )  faulty += '- tomcat5-server-lib-5.5.23-0jpp.1.0.3.el5\n';
if ( rpm_check(reference:"tomcat5-servlet-2.4-api-5.5.23-0jpp.1.0.3.el5", release:"CentOS-5", cpu:"x86_64") )  faulty += '- tomcat5-servlet-2.4-api-5.5.23-0jpp.1.0.3.el5\n';
if ( rpm_check(reference:"tomcat5-servlet-2.4-api-javadoc-5.5.23-0jpp.1.0.3.el5", release:"CentOS-5", cpu:"x86_64") )  faulty += '- tomcat5-servlet-2.4-api-javadoc-5.5.23-0jpp.1.0.3.el5\n';
if ( rpm_check(reference:"tomcat5-webapps-5.5.23-0jpp.1.0.3.el5", release:"CentOS-5", cpu:"x86_64") )  faulty += '- tomcat5-webapps-5.5.23-0jpp.1.0.3.el5\n';
if ( faulty ) security_hole(port:0, data:desc + '\n\nPlugin output :\n\nThe following RPMs need to be updated :\n' + faulty);
