#
# (C) Tenable Network Security, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);
desc = "
Synopsis :

The remote host is missing a security update.

Description :

The remote CentOS system is missing a security update which has been 
documented in Red Hat advisory RHSA-2007-0348.

See also :

https://rhn.redhat.com/errata/RHSA-2007-0348.html

Solution :

Upgrade to the newest packages by doing :

  yum update

Risk factor :

High";

if ( description )
{
 script_id(25206);
 script_version("$Revision: 1.2 $");
 script_name(english:"CentOS : RHSA-2007-0348");
 script_description(english:desc);

 script_summary(english:"Checks for missing updates on the remote CentOS system");
 script_category(ACT_GATHER_INFO);
 script_copyright(english:"This script is (C) 2007 Tenable Network Security, Inc.");
 script_family(english:"CentOS Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/CentOS/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check(reference:"php-5.1.6-12.el5", release:"CentOS-5", cpu:"i386") )  faulty += '- php-5.1.6-12.el5\n';
if ( rpm_check(reference:"php-bcmath-5.1.6-12.el5", release:"CentOS-5", cpu:"i386") )  faulty += '- php-bcmath-5.1.6-12.el5\n';
if ( rpm_check(reference:"php-cli-5.1.6-12.el5", release:"CentOS-5", cpu:"i386") )  faulty += '- php-cli-5.1.6-12.el5\n';
if ( rpm_check(reference:"php-common-5.1.6-12.el5", release:"CentOS-5", cpu:"i386") )  faulty += '- php-common-5.1.6-12.el5\n';
if ( rpm_check(reference:"php-dba-5.1.6-12.el5", release:"CentOS-5", cpu:"i386") )  faulty += '- php-dba-5.1.6-12.el5\n';
if ( rpm_check(reference:"php-devel-5.1.6-12.el5", release:"CentOS-5", cpu:"i386") )  faulty += '- php-devel-5.1.6-12.el5\n';
if ( rpm_check(reference:"php-gd-5.1.6-12.el5", release:"CentOS-5", cpu:"i386") )  faulty += '- php-gd-5.1.6-12.el5\n';
if ( rpm_check(reference:"php-imap-5.1.6-12.el5", release:"CentOS-5", cpu:"i386") )  faulty += '- php-imap-5.1.6-12.el5\n';
if ( rpm_check(reference:"php-ldap-5.1.6-12.el5", release:"CentOS-5", cpu:"i386") )  faulty += '- php-ldap-5.1.6-12.el5\n';
if ( rpm_check(reference:"php-mbstring-5.1.6-12.el5", release:"CentOS-5", cpu:"i386") )  faulty += '- php-mbstring-5.1.6-12.el5\n';
if ( rpm_check(reference:"php-mysql-5.1.6-12.el5", release:"CentOS-5", cpu:"i386") )  faulty += '- php-mysql-5.1.6-12.el5\n';
if ( rpm_check(reference:"php-ncurses-5.1.6-12.el5", release:"CentOS-5", cpu:"i386") )  faulty += '- php-ncurses-5.1.6-12.el5\n';
if ( rpm_check(reference:"php-odbc-5.1.6-12.el5", release:"CentOS-5", cpu:"i386") )  faulty += '- php-odbc-5.1.6-12.el5\n';
if ( rpm_check(reference:"php-pdo-5.1.6-12.el5", release:"CentOS-5", cpu:"i386") )  faulty += '- php-pdo-5.1.6-12.el5\n';
if ( rpm_check(reference:"php-pgsql-5.1.6-12.el5", release:"CentOS-5", cpu:"i386") )  faulty += '- php-pgsql-5.1.6-12.el5\n';
if ( rpm_check(reference:"php-snmp-5.1.6-12.el5", release:"CentOS-5", cpu:"i386") )  faulty += '- php-snmp-5.1.6-12.el5\n';
if ( rpm_check(reference:"php-soap-5.1.6-12.el5", release:"CentOS-5", cpu:"i386") )  faulty += '- php-soap-5.1.6-12.el5\n';
if ( rpm_check(reference:"php-xml-5.1.6-12.el5", release:"CentOS-5", cpu:"i386") )  faulty += '- php-xml-5.1.6-12.el5\n';
if ( rpm_check(reference:"php-xmlrpc-5.1.6-12.el5", release:"CentOS-5", cpu:"i386") )  faulty += '- php-xmlrpc-5.1.6-12.el5\n';
if ( rpm_check(reference:"php-5.1.6-12.el5", release:"CentOS-5", cpu:"x86_64") )  faulty += '- php-5.1.6-12.el5\n';
if ( rpm_check(reference:"php-bcmath-5.1.6-12.el5", release:"CentOS-5", cpu:"x86_64") )  faulty += '- php-bcmath-5.1.6-12.el5\n';
if ( rpm_check(reference:"php-cli-5.1.6-12.el5", release:"CentOS-5", cpu:"x86_64") )  faulty += '- php-cli-5.1.6-12.el5\n';
if ( rpm_check(reference:"php-common-5.1.6-12.el5", release:"CentOS-5", cpu:"x86_64") )  faulty += '- php-common-5.1.6-12.el5\n';
if ( rpm_check(reference:"php-dba-5.1.6-12.el5", release:"CentOS-5", cpu:"x86_64") )  faulty += '- php-dba-5.1.6-12.el5\n';
if ( rpm_check(reference:"php-devel-5.1.6-12.el5", release:"CentOS-5", cpu:"x86_64") )  faulty += '- php-devel-5.1.6-12.el5\n';
if ( rpm_check(reference:"php-gd-5.1.6-12.el5", release:"CentOS-5", cpu:"x86_64") )  faulty += '- php-gd-5.1.6-12.el5\n';
if ( rpm_check(reference:"php-imap-5.1.6-12.el5", release:"CentOS-5", cpu:"x86_64") )  faulty += '- php-imap-5.1.6-12.el5\n';
if ( rpm_check(reference:"php-ldap-5.1.6-12.el5", release:"CentOS-5", cpu:"x86_64") )  faulty += '- php-ldap-5.1.6-12.el5\n';
if ( rpm_check(reference:"php-mbstring-5.1.6-12.el5", release:"CentOS-5", cpu:"x86_64") )  faulty += '- php-mbstring-5.1.6-12.el5\n';
if ( rpm_check(reference:"php-mysql-5.1.6-12.el5", release:"CentOS-5", cpu:"x86_64") )  faulty += '- php-mysql-5.1.6-12.el5\n';
if ( rpm_check(reference:"php-ncurses-5.1.6-12.el5", release:"CentOS-5", cpu:"x86_64") )  faulty += '- php-ncurses-5.1.6-12.el5\n';
if ( rpm_check(reference:"php-odbc-5.1.6-12.el5", release:"CentOS-5", cpu:"x86_64") )  faulty += '- php-odbc-5.1.6-12.el5\n';
if ( rpm_check(reference:"php-pdo-5.1.6-12.el5", release:"CentOS-5", cpu:"x86_64") )  faulty += '- php-pdo-5.1.6-12.el5\n';
if ( rpm_check(reference:"php-pgsql-5.1.6-12.el5", release:"CentOS-5", cpu:"x86_64") )  faulty += '- php-pgsql-5.1.6-12.el5\n';
if ( rpm_check(reference:"php-snmp-5.1.6-12.el5", release:"CentOS-5", cpu:"x86_64") )  faulty += '- php-snmp-5.1.6-12.el5\n';
if ( rpm_check(reference:"php-soap-5.1.6-12.el5", release:"CentOS-5", cpu:"x86_64") )  faulty += '- php-soap-5.1.6-12.el5\n';
if ( rpm_check(reference:"php-xml-5.1.6-12.el5", release:"CentOS-5", cpu:"x86_64") )  faulty += '- php-xml-5.1.6-12.el5\n';
if ( rpm_check(reference:"php-xmlrpc-5.1.6-12.el5", release:"CentOS-5", cpu:"x86_64") )  faulty += '- php-xmlrpc-5.1.6-12.el5\n';
if ( faulty ) security_hole(port:0, data:desc + '\n\nPlugin output :\n\nThe following RPMs need to be updated :\n' + faulty);
