#
# (C) Tenable Network Security, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);
desc = "
Synopsis :

The remote host is missing a security update.

Description :

The remote CentOS system is missing a security update which has been 
documented in Red Hat advisory RHSA-2007-0473.

See also :

https://rhn.redhat.com/errata/RHSA-2007-0473.html

Solution :

Upgrade to the newest packages by doing :

  yum update

Risk factor :

High";

if ( description )
{
 script_id(25501);
 script_version("$Revision: 1.2 $");
 script_name(english:"CentOS : RHSA-2007-0473");
 script_description(english:desc);

 script_summary(english:"Checks for missing updates on the remote CentOS system");
 script_category(ACT_GATHER_INFO);
 script_copyright(english:"This script is (C) 2007 Tenable Network Security, Inc.");
 script_family(english:"CentOS Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/CentOS/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check(reference:"cpp-3.2.3-59", release:"CentOS-3", cpu:"ia64") )  faulty += '- cpp-3.2.3-59\n';
if ( rpm_check(reference:"gcc-3.2.3-59", release:"CentOS-3", cpu:"ia64") )  faulty += '- gcc-3.2.3-59\n';
if ( rpm_check(reference:"gcc-c++-3.2.3-59", release:"CentOS-3", cpu:"ia64") )  faulty += '- gcc-c++-3.2.3-59\n';
if ( rpm_check(reference:"gcc-g77-3.2.3-59", release:"CentOS-3", cpu:"ia64") )  faulty += '- gcc-g77-3.2.3-59\n';
if ( rpm_check(reference:"gcc-gnat-3.2.3-59", release:"CentOS-3", cpu:"ia64") )  faulty += '- gcc-gnat-3.2.3-59\n';
if ( rpm_check(reference:"gcc-java-3.2.3-59", release:"CentOS-3", cpu:"ia64") )  faulty += '- gcc-java-3.2.3-59\n';
if ( rpm_check(reference:"gcc-objc-3.2.3-59", release:"CentOS-3", cpu:"ia64") )  faulty += '- gcc-objc-3.2.3-59\n';
if ( rpm_check(reference:"libf2c-3.2.3-59", release:"CentOS-3", cpu:"ia64") )  faulty += '- libf2c-3.2.3-59\n';
if ( rpm_check(reference:"libgcc-3.2.3-59", release:"CentOS-3", cpu:"ia64") )  faulty += '- libgcc-3.2.3-59\n';
if ( rpm_check(reference:"libgcj-3.2.3-59", release:"CentOS-3", cpu:"ia64") )  faulty += '- libgcj-3.2.3-59\n';
if ( rpm_check(reference:"libgcj-devel-3.2.3-59", release:"CentOS-3", cpu:"ia64") )  faulty += '- libgcj-devel-3.2.3-59\n';
if ( rpm_check(reference:"libgnat-3.2.3-59", release:"CentOS-3", cpu:"ia64") )  faulty += '- libgnat-3.2.3-59\n';
if ( rpm_check(reference:"libobjc-3.2.3-59", release:"CentOS-3", cpu:"ia64") )  faulty += '- libobjc-3.2.3-59\n';
if ( rpm_check(reference:"libstdc++-3.2.3-59", release:"CentOS-3", cpu:"ia64") )  faulty += '- libstdc++-3.2.3-59\n';
if ( rpm_check(reference:"libstdc++-devel-3.2.3-59", release:"CentOS-3", cpu:"ia64") )  faulty += '- libstdc++-devel-3.2.3-59\n';
if ( rpm_check(reference:"cpp-3.2.3-59", release:"CentOS-3", cpu:"i386") )  faulty += '- cpp-3.2.3-59\n';
if ( rpm_check(reference:"gcc-3.2.3-59", release:"CentOS-3", cpu:"i386") )  faulty += '- gcc-3.2.3-59\n';
if ( rpm_check(reference:"gcc-c++-3.2.3-59", release:"CentOS-3", cpu:"i386") )  faulty += '- gcc-c++-3.2.3-59\n';
if ( rpm_check(reference:"gcc-g77-3.2.3-59", release:"CentOS-3", cpu:"i386") )  faulty += '- gcc-g77-3.2.3-59\n';
if ( rpm_check(reference:"gcc-gnat-3.2.3-59", release:"CentOS-3", cpu:"i386") )  faulty += '- gcc-gnat-3.2.3-59\n';
if ( rpm_check(reference:"gcc-java-3.2.3-59", release:"CentOS-3", cpu:"i386") )  faulty += '- gcc-java-3.2.3-59\n';
if ( rpm_check(reference:"gcc-objc-3.2.3-59", release:"CentOS-3", cpu:"i386") )  faulty += '- gcc-objc-3.2.3-59\n';
if ( rpm_check(reference:"libf2c-3.2.3-59", release:"CentOS-3", cpu:"i386") )  faulty += '- libf2c-3.2.3-59\n';
if ( rpm_check(reference:"libgcc-3.2.3-59", release:"CentOS-3", cpu:"i386") )  faulty += '- libgcc-3.2.3-59\n';
if ( rpm_check(reference:"libgcj-3.2.3-59", release:"CentOS-3", cpu:"i386") )  faulty += '- libgcj-3.2.3-59\n';
if ( rpm_check(reference:"libgcj-devel-3.2.3-59", release:"CentOS-3", cpu:"i386") )  faulty += '- libgcj-devel-3.2.3-59\n';
if ( rpm_check(reference:"libgnat-3.2.3-59", release:"CentOS-3", cpu:"i386") )  faulty += '- libgnat-3.2.3-59\n';
if ( rpm_check(reference:"libobjc-3.2.3-59", release:"CentOS-3", cpu:"i386") )  faulty += '- libobjc-3.2.3-59\n';
if ( rpm_check(reference:"libstdc++-3.2.3-59", release:"CentOS-3", cpu:"i386") )  faulty += '- libstdc++-3.2.3-59\n';
if ( rpm_check(reference:"libstdc++-devel-3.2.3-59", release:"CentOS-3", cpu:"i386") )  faulty += '- libstdc++-devel-3.2.3-59\n';
if ( rpm_check(reference:"cpp-3.2.3-59", release:"CentOS-3", cpu:"x86_64") )  faulty += '- cpp-3.2.3-59\n';
if ( rpm_check(reference:"gcc-3.2.3-59", release:"CentOS-3", cpu:"x86_64") )  faulty += '- gcc-3.2.3-59\n';
if ( rpm_check(reference:"gcc-c++-3.2.3-59", release:"CentOS-3", cpu:"x86_64") )  faulty += '- gcc-c++-3.2.3-59\n';
if ( rpm_check(reference:"gcc-g77-3.2.3-59", release:"CentOS-3", cpu:"x86_64") )  faulty += '- gcc-g77-3.2.3-59\n';
if ( rpm_check(reference:"gcc-gnat-3.2.3-59", release:"CentOS-3", cpu:"x86_64") )  faulty += '- gcc-gnat-3.2.3-59\n';
if ( rpm_check(reference:"gcc-java-3.2.3-59", release:"CentOS-3", cpu:"x86_64") )  faulty += '- gcc-java-3.2.3-59\n';
if ( rpm_check(reference:"gcc-objc-3.2.3-59", release:"CentOS-3", cpu:"x86_64") )  faulty += '- gcc-objc-3.2.3-59\n';
if ( rpm_check(reference:"libf2c-3.2.3-59", release:"CentOS-3", cpu:"x86_64") )  faulty += '- libf2c-3.2.3-59\n';
if ( rpm_check(reference:"libgcc-3.2.3-59", release:"CentOS-3", cpu:"x86_64") )  faulty += '- libgcc-3.2.3-59\n';
if ( rpm_check(reference:"libgcj-3.2.3-59", release:"CentOS-3", cpu:"x86_64") )  faulty += '- libgcj-3.2.3-59\n';
if ( rpm_check(reference:"libgcj-devel-3.2.3-59", release:"CentOS-3", cpu:"x86_64") )  faulty += '- libgcj-devel-3.2.3-59\n';
if ( rpm_check(reference:"libgnat-3.2.3-59", release:"CentOS-3", cpu:"x86_64") )  faulty += '- libgnat-3.2.3-59\n';
if ( rpm_check(reference:"libobjc-3.2.3-59", release:"CentOS-3", cpu:"x86_64") )  faulty += '- libobjc-3.2.3-59\n';
if ( rpm_check(reference:"libstdc++-3.2.3-59", release:"CentOS-3", cpu:"x86_64") )  faulty += '- libstdc++-3.2.3-59\n';
if ( rpm_check(reference:"libstdc++-devel-3.2.3-59", release:"CentOS-3", cpu:"x86_64") )  faulty += '- libstdc++-devel-3.2.3-59\n';
if ( faulty ) security_hole(port:0, data:desc + '\n\nPlugin output :\n\nThe following RPMs need to be updated :\n' + faulty);
