#
# (C) Tenable Network Security, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);
desc = "
Synopsis :

The remote host is missing a security update.

Description :

The remote CentOS system is missing a security update which has been 
documented in Red Hat advisory RHSA-2007-0883.

See also :

https://rhn.redhat.com/errata/RHSA-2007-0883.html

Solution :

Upgrade to the newest packages by doing :

  yum update

Risk factor :

High";

if ( description )
{
 script_id(26028);
 script_version("$Revision: 1.3 $");
 script_name(english:"CentOS : RHSA-2007-0883");
 script_description(english:desc);

 script_summary(english:"Checks for missing updates on the remote CentOS system");
 script_category(ACT_GATHER_INFO);
 script_copyright(english:"This script is (C) 2007 Tenable Network Security, Inc.");
 script_family(english:"CentOS Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/CentOS/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check(reference:"qt-3.1.2-17.RHEL3", release:"CentOS-3", cpu:"i386") )  faulty += '- qt-3.1.2-17.RHEL3\n';
if ( rpm_check(reference:"qt-config-3.1.2-17.RHEL3", release:"CentOS-3", cpu:"i386") )  faulty += '- qt-config-3.1.2-17.RHEL3\n';
if ( rpm_check(reference:"qt-designer-3.1.2-17.RHEL3", release:"CentOS-3", cpu:"i386") )  faulty += '- qt-designer-3.1.2-17.RHEL3\n';
if ( rpm_check(reference:"qt-devel-3.1.2-17.RHEL3", release:"CentOS-3", cpu:"i386") )  faulty += '- qt-devel-3.1.2-17.RHEL3\n';
if ( rpm_check(reference:"qt-MySQL-3.1.2-17.RHEL3", release:"CentOS-3", cpu:"i386") )  faulty += '- qt-MySQL-3.1.2-17.RHEL3\n';
if ( rpm_check(reference:"qt-ODBC-3.1.2-17.RHEL3", release:"CentOS-3", cpu:"i386") )  faulty += '- qt-ODBC-3.1.2-17.RHEL3\n';
if ( rpm_check(reference:"qt-PostgreSQL-3.1.2-17.RHEL3", release:"CentOS-3", cpu:"i386") )  faulty += '- qt-PostgreSQL-3.1.2-17.RHEL3\n';
if ( rpm_check(reference:"qt-3.1.2-17.RHEL3", release:"CentOS-3", cpu:"x86_64") )  faulty += '- qt-3.1.2-17.RHEL3\n';
if ( rpm_check(reference:"qt-config-3.1.2-17.RHEL3", release:"CentOS-3", cpu:"x86_64") )  faulty += '- qt-config-3.1.2-17.RHEL3\n';
if ( rpm_check(reference:"qt-designer-3.1.2-17.RHEL3", release:"CentOS-3", cpu:"x86_64") )  faulty += '- qt-designer-3.1.2-17.RHEL3\n';
if ( rpm_check(reference:"qt-devel-3.1.2-17.RHEL3", release:"CentOS-3", cpu:"x86_64") )  faulty += '- qt-devel-3.1.2-17.RHEL3\n';
if ( rpm_check(reference:"qt-MySQL-3.1.2-17.RHEL3", release:"CentOS-3", cpu:"x86_64") )  faulty += '- qt-MySQL-3.1.2-17.RHEL3\n';
if ( rpm_check(reference:"qt-ODBC-3.1.2-17.RHEL3", release:"CentOS-3", cpu:"x86_64") )  faulty += '- qt-ODBC-3.1.2-17.RHEL3\n';
if ( rpm_check(reference:"qt-PostgreSQL-3.1.2-17.RHEL3", release:"CentOS-3", cpu:"x86_64") )  faulty += '- qt-PostgreSQL-3.1.2-17.RHEL3\n';
if ( rpm_check(reference:"qt-3.3.3-13.RHEL4", release:"CentOS-4", cpu:"ia64") )  faulty += '- qt-3.3.3-13.RHEL4\n';
if ( rpm_check(reference:"qt-MySQL-3.3.3-13.RHEL4", release:"CentOS-4", cpu:"ia64") )  faulty += '- qt-MySQL-3.3.3-13.RHEL4\n';
if ( rpm_check(reference:"qt-ODBC-3.3.3-13.RHEL4", release:"CentOS-4", cpu:"ia64") )  faulty += '- qt-ODBC-3.3.3-13.RHEL4\n';
if ( rpm_check(reference:"qt-PostgreSQL-3.3.3-13.RHEL4", release:"CentOS-4", cpu:"ia64") )  faulty += '- qt-PostgreSQL-3.3.3-13.RHEL4\n';
if ( rpm_check(reference:"qt-config-3.3.3-13.RHEL4", release:"CentOS-4", cpu:"ia64") )  faulty += '- qt-config-3.3.3-13.RHEL4\n';
if ( rpm_check(reference:"qt-designer-3.3.3-13.RHEL4", release:"CentOS-4", cpu:"ia64") )  faulty += '- qt-designer-3.3.3-13.RHEL4\n';
if ( rpm_check(reference:"qt-devel-3.3.3-13.RHEL4", release:"CentOS-4", cpu:"ia64") )  faulty += '- qt-devel-3.3.3-13.RHEL4\n';
if ( rpm_check(reference:"qt-3.1.2-17.RHEL3", release:"CentOS-3", cpu:"ia64") )  faulty += '- qt-3.1.2-17.RHEL3\n';
if ( rpm_check(reference:"qt-MySQL-3.1.2-17.RHEL3", release:"CentOS-3", cpu:"ia64") )  faulty += '- qt-MySQL-3.1.2-17.RHEL3\n';
if ( rpm_check(reference:"qt-ODBC-3.1.2-17.RHEL3", release:"CentOS-3", cpu:"ia64") )  faulty += '- qt-ODBC-3.1.2-17.RHEL3\n';
if ( rpm_check(reference:"qt-PostgreSQL-3.1.2-17.RHEL3", release:"CentOS-3", cpu:"ia64") )  faulty += '- qt-PostgreSQL-3.1.2-17.RHEL3\n';
if ( rpm_check(reference:"qt-config-3.1.2-17.RHEL3", release:"CentOS-3", cpu:"ia64") )  faulty += '- qt-config-3.1.2-17.RHEL3\n';
if ( rpm_check(reference:"qt-designer-3.1.2-17.RHEL3", release:"CentOS-3", cpu:"ia64") )  faulty += '- qt-designer-3.1.2-17.RHEL3\n';
if ( rpm_check(reference:"qt-devel-3.1.2-17.RHEL3", release:"CentOS-3", cpu:"ia64") )  faulty += '- qt-devel-3.1.2-17.RHEL3\n';
if ( rpm_check(reference:"qt-3.3.3-13.RHEL4", release:"CentOS-4", cpu:"i386") )  faulty += '- qt-3.3.3-13.RHEL4\n';
if ( rpm_check(reference:"qt-config-3.3.3-13.RHEL4", release:"CentOS-4", cpu:"i386") )  faulty += '- qt-config-3.3.3-13.RHEL4\n';
if ( rpm_check(reference:"qt-designer-3.3.3-13.RHEL4", release:"CentOS-4", cpu:"i386") )  faulty += '- qt-designer-3.3.3-13.RHEL4\n';
if ( rpm_check(reference:"qt-devel-3.3.3-13.RHEL4", release:"CentOS-4", cpu:"i386") )  faulty += '- qt-devel-3.3.3-13.RHEL4\n';
if ( rpm_check(reference:"qt-MySQL-3.3.3-13.RHEL4", release:"CentOS-4", cpu:"i386") )  faulty += '- qt-MySQL-3.3.3-13.RHEL4\n';
if ( rpm_check(reference:"qt-ODBC-3.3.3-13.RHEL4", release:"CentOS-4", cpu:"i386") )  faulty += '- qt-ODBC-3.3.3-13.RHEL4\n';
if ( rpm_check(reference:"qt-PostgreSQL-3.3.3-13.RHEL4", release:"CentOS-4", cpu:"i386") )  faulty += '- qt-PostgreSQL-3.3.3-13.RHEL4\n';
if ( rpm_check(reference:"qt-3.3.3-13.RHEL4", release:"CentOS-4", cpu:"x86_64") )  faulty += '- qt-3.3.3-13.RHEL4\n';
if ( rpm_check(reference:"qt-config-3.3.3-13.RHEL4", release:"CentOS-4", cpu:"x86_64") )  faulty += '- qt-config-3.3.3-13.RHEL4\n';
if ( rpm_check(reference:"qt-designer-3.3.3-13.RHEL4", release:"CentOS-4", cpu:"x86_64") )  faulty += '- qt-designer-3.3.3-13.RHEL4\n';
if ( rpm_check(reference:"qt-devel-3.3.3-13.RHEL4", release:"CentOS-4", cpu:"x86_64") )  faulty += '- qt-devel-3.3.3-13.RHEL4\n';
if ( rpm_check(reference:"qt-MySQL-3.3.3-13.RHEL4", release:"CentOS-4", cpu:"x86_64") )  faulty += '- qt-MySQL-3.3.3-13.RHEL4\n';
if ( rpm_check(reference:"qt-ODBC-3.3.3-13.RHEL4", release:"CentOS-4", cpu:"x86_64") )  faulty += '- qt-ODBC-3.3.3-13.RHEL4\n';
if ( rpm_check(reference:"qt-PostgreSQL-3.3.3-13.RHEL4", release:"CentOS-4", cpu:"x86_64") )  faulty += '- qt-PostgreSQL-3.3.3-13.RHEL4\n';
if ( faulty ) security_hole(port:0, data:desc + '\n\nPlugin output :\n\nThe following RPMs need to be updated :\n' + faulty);
