#
# (C) Tenable Network Security, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);
desc = "
Synopsis :

The remote host is missing a security update.

Description :

The remote CentOS system is missing a security update which has been 
documented in Red Hat advisory RHSA-2008-0134.

See also :

https://rhn.redhat.com/errata/RHSA-2008-0134.html

Solution :

Upgrade to the newest packages by doing :

  yum update

Risk factor :

High";

if ( description )
{
 script_id(31139);
 script_version("$Revision: 1.1 $");
 script_name(english:"CentOS : RHSA-2008-0134");
 script_description(english:desc);

 script_summary(english:"Checks for missing updates on the remote CentOS system");
 script_category(ACT_GATHER_INFO);
 script_copyright(english:"This script is (C) 2008 Tenable Network Security, Inc.");
 script_family(english:"CentOS Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/CentOS/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check(reference:"expect-5.38.0-92.8.c3", release:"CentOS-3", cpu:"ia64") )  faulty += '- expect-5.38.0-92.8.c3\n';
if ( rpm_check(reference:"expect-devel-5.38.0-92.8.c3", release:"CentOS-3", cpu:"ia64") )  faulty += '- expect-devel-5.38.0-92.8.c3\n';
if ( rpm_check(reference:"expectk-5.38.0-92.8.c3", release:"CentOS-3", cpu:"ia64") )  faulty += '- expectk-5.38.0-92.8.c3\n';
if ( rpm_check(reference:"itcl-3.2-92.8.c3", release:"CentOS-3", cpu:"ia64") )  faulty += '- itcl-3.2-92.8.c3\n';
if ( rpm_check(reference:"tcl-8.3.5-92.8.c3", release:"CentOS-3", cpu:"ia64") )  faulty += '- tcl-8.3.5-92.8.c3\n';
if ( rpm_check(reference:"tcl-devel-8.3.5-92.8.c3", release:"CentOS-3", cpu:"ia64") )  faulty += '- tcl-devel-8.3.5-92.8.c3\n';
if ( rpm_check(reference:"tcl-html-8.3.5-92.8.c3", release:"CentOS-3", cpu:"ia64") )  faulty += '- tcl-html-8.3.5-92.8.c3\n';
if ( rpm_check(reference:"tcllib-1.3-92.8.c3", release:"CentOS-3", cpu:"ia64") )  faulty += '- tcllib-1.3-92.8.c3\n';
if ( rpm_check(reference:"tclx-8.3-92.8.c3", release:"CentOS-3", cpu:"ia64") )  faulty += '- tclx-8.3-92.8.c3\n';
if ( rpm_check(reference:"tix-8.1.4-92.8.c3", release:"CentOS-3", cpu:"ia64") )  faulty += '- tix-8.1.4-92.8.c3\n';
if ( rpm_check(reference:"tk-8.3.5-92.8.c3", release:"CentOS-3", cpu:"ia64") )  faulty += '- tk-8.3.5-92.8.c3\n';
if ( rpm_check(reference:"tk-devel-8.3.5-92.8.c3", release:"CentOS-3", cpu:"ia64") )  faulty += '- tk-devel-8.3.5-92.8.c3\n';
if ( rpm_check(reference:"expect-5.38.0-92.8", release:"CentOS-3", cpu:"i386") )  faulty += '- expect-5.38.0-92.8\n';
if ( rpm_check(reference:"expect-devel-5.38.0-92.8", release:"CentOS-3", cpu:"i386") )  faulty += '- expect-devel-5.38.0-92.8\n';
if ( rpm_check(reference:"itcl-3.2-92.8", release:"CentOS-3", cpu:"i386") )  faulty += '- itcl-3.2-92.8\n';
if ( rpm_check(reference:"tcl-8.3.5-92.8", release:"CentOS-3", cpu:"i386") )  faulty += '- tcl-8.3.5-92.8\n';
if ( rpm_check(reference:"tcl-devel-8.3.5-92.8", release:"CentOS-3", cpu:"i386") )  faulty += '- tcl-devel-8.3.5-92.8\n';
if ( rpm_check(reference:"tclx-8.3-92.8", release:"CentOS-3", cpu:"i386") )  faulty += '- tclx-8.3-92.8\n';
if ( rpm_check(reference:"tix-8.1.4-92.8", release:"CentOS-3", cpu:"i386") )  faulty += '- tix-8.1.4-92.8\n';
if ( rpm_check(reference:"tk-8.3.5-92.8", release:"CentOS-3", cpu:"i386") )  faulty += '- tk-8.3.5-92.8\n';
if ( rpm_check(reference:"tk-devel-8.3.5-92.8", release:"CentOS-3", cpu:"i386") )  faulty += '- tk-devel-8.3.5-92.8\n';
if ( rpm_check(reference:"expectk-5.38.0-92.8", release:"CentOS-3", cpu:"i386") )  faulty += '- expectk-5.38.0-92.8\n';
if ( rpm_check(reference:"tcl-html-8.3.5-92.8", release:"CentOS-3", cpu:"i386") )  faulty += '- tcl-html-8.3.5-92.8\n';
if ( rpm_check(reference:"tcllib-1.3-92.8", release:"CentOS-3", cpu:"i386") )  faulty += '- tcllib-1.3-92.8\n';
if ( rpm_check(reference:"expect-5.38.0-92.8", release:"CentOS-3", cpu:"x86_64") )  faulty += '- expect-5.38.0-92.8\n';
if ( rpm_check(reference:"expect-devel-5.38.0-92.8", release:"CentOS-3", cpu:"x86_64") )  faulty += '- expect-devel-5.38.0-92.8\n';
if ( rpm_check(reference:"itcl-3.2-92.8", release:"CentOS-3", cpu:"x86_64") )  faulty += '- itcl-3.2-92.8\n';
if ( rpm_check(reference:"tcl-8.3.5-92.8", release:"CentOS-3", cpu:"x86_64") )  faulty += '- tcl-8.3.5-92.8\n';
if ( rpm_check(reference:"tcl-devel-8.3.5-92.8", release:"CentOS-3", cpu:"x86_64") )  faulty += '- tcl-devel-8.3.5-92.8\n';
if ( rpm_check(reference:"tclx-8.3-92.8", release:"CentOS-3", cpu:"x86_64") )  faulty += '- tclx-8.3-92.8\n';
if ( rpm_check(reference:"tix-8.1.4-92.8", release:"CentOS-3", cpu:"x86_64") )  faulty += '- tix-8.1.4-92.8\n';
if ( rpm_check(reference:"tk-8.3.5-92.8", release:"CentOS-3", cpu:"x86_64") )  faulty += '- tk-8.3.5-92.8\n';
if ( rpm_check(reference:"tk-devel-8.3.5-92.8", release:"CentOS-3", cpu:"x86_64") )  faulty += '- tk-devel-8.3.5-92.8\n';
if ( rpm_check(reference:"expectk-5.38.0-92.8", release:"CentOS-3", cpu:"x86_64") )  faulty += '- expectk-5.38.0-92.8\n';
if ( rpm_check(reference:"tcl-html-8.3.5-92.8", release:"CentOS-3", cpu:"x86_64") )  faulty += '- tcl-html-8.3.5-92.8\n';
if ( rpm_check(reference:"tcllib-1.3-92.8", release:"CentOS-3", cpu:"x86_64") )  faulty += '- tcllib-1.3-92.8\n';
if ( faulty ) security_hole(port:0, data:desc + '\n\nPlugin output :\n\nThe following RPMs need to be updated :\n' + faulty);
