#
# (C) Tenable Network Security, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);
desc = "
Synopsis :

The remote host is missing a security update.

Description :

The remote CentOS system is missing a security update which has been 
documented in Red Hat advisory RHSA-2008-0136.

See also :

https://rhn.redhat.com/errata/RHSA-2008-0136.html

Solution :

Upgrade to the newest packages by doing :

  yum update

Risk factor :

High";

if ( description )
{
 script_id(31141);
 script_version("$Revision: 1.1 $");
 script_name(english:"CentOS : RHSA-2008-0136");
 script_description(english:desc);

 script_summary(english:"Checks for missing updates on the remote CentOS system");
 script_category(ACT_GATHER_INFO);
 script_copyright(english:"This script is (C) 2008 Tenable Network Security, Inc.");
 script_family(english:"CentOS Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/CentOS/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check(reference:"tk-8.4.13-5.el5_1.1", release:"CentOS-5", cpu:"i386") )  faulty += '- tk-8.4.13-5.el5_1.1\n';
if ( rpm_check(reference:"tk-devel-8.4.13-5.el5_1.1", release:"CentOS-5", cpu:"i386") )  faulty += '- tk-devel-8.4.13-5.el5_1.1\n';
if ( faulty ) security_hole(port:0, data:desc + '\n\nPlugin output :\n\nThe following RPMs need to be updated :\n' + faulty);
