# This script was written by Michel Arboi
#
# It is released under the GNU Public Licence (GPL v2)
# For now.
# Unless I change my mind if you don't stop complaining about Nessus
# going commercial
# <grin>


if(description)
{
 script_id(17230);
 script_version("$Revision: 1.7 $");
 
 name["english"] = "CERN HTTPD access control bypass";
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis : 

The remote web server is affected by an information disclosure
vulnerability. 

Description :

The remote web server allows an attacker to access proteected web
pages by replacing slashes in the URL with '//' or '/./', which is a
known problem in older versions of CERN web server. 

Solution : 

Contact the web server vendor for an update or tighten its filtering
rules to reject patterns such as :

  //*
  *//*
  /./* 
  */./*

Risk factor :

Medium / CVSS Base Score : 5.0
(CVSS2#AV:N/AC:L/Au:N/C:P/I:N/A:N)";
 script_description(english:desc["english"]);
 
 summary["english"] = "Determines if web access control can be circumvented";
 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2005 Michel Arboi");
 family["english"] = "Web Servers";
 script_family(english:family["english"]);
 script_dependencie("find_service1.nasl", "http_version.nasl", "webmirror.nasl", "no404.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

# Check starts here

include("http_func.inc");
include("http_keepalive.inc");
include("global_settings.inc");

# If this script gives FP, uncomment the next line
if (report_paranoia < 2) exit(0);	# Disable with "Avoid false alarms" 

port = get_http_port(default:80);
if (! get_port_state(port)) exit(0);

no404 = get_kb_item(strcat('www/no404/', port));

function check(port, loc)
{
 local_var	req, res;
 req = http_get(item:loc, port:port);
 res = http_keepalive_send_recv(port:port, data:req);
 if (isnull(res)) exit(0);
 if (res =~ "^HTTP/[0-9]\.[0-9] +40[13]") return 403;
 else if (res =~ "^HTTP/[0-9]\.[0-9] +200 ")
 {
   if (no404 && no404 >< res) return 404;
   else return 200;
 }
 else return NULL;
}

dirs = get_kb_list(strcat("www/", port, "/content/auth_required"));
if (isnull(dirs)) exit(0);

foreach dir (dirs)
{
  if (check(port: port, loc: dir) == 403)
  {
    foreach pat (make_list("//", "/./"))
    {
      dir2 = ereg_replace(pattern: "^/", replace: pat, string: dir);
      if (check(port: port, loc: dir2) == 200)
      {
        debug_print('>', dir2, '< can be read on ', get_host_name(),
	':', port, '\n');
        security_warning(port: port);
        exit(0);
      }

      dir2 = ereg_replace(pattern: "^(.+)/", replace: "\\1"+pat, string: dir);
      if (check(port: port, loc: dir2) == 200)
      {
        debug_print('>', dir2, '< can be read on ', get_host_name(),
	':', port, '\n');
        security_warning(port: port);
        exit(0);
      }
    }
  }
}
