#
# This script was written by Michel Arboi <arboi@alussinan.org> 
#
# GPL, blah blah blah
# See the Nessus Scripts License for details
#
# Services known to crash or freeze on a port scan:
#
# ClearCase (TCP/371)
# NetBackup
# 
################
# References
################
#
# From: marek.rouchal@infineon.com
# To: bugtraq@securityfocus.com, vulnwatch@vulnwatch.org, 
#   submissions@packetstormsecurity.org
# CC: rheinold@rational.com, buggy@segmentationfault.de, 
#    Thorsten.Delbrouck@guardeonic.com, manfred.korger@infineon.com
# Date: Fri, 22 Nov 2002 10:30:11 +0100
# Subject: ClearCase DoS vulnerabilty
#
################
# Changes
################
#
# Edited by Herman Young <herman@sensepost.com>

if(description)
{
 script_id(10919);
 script_version ("$Revision: 1.26 $");

 name["english"] = "Check open ports";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
During the Scan a port that was previously open has now closed. 

There exist numerous possible causes for this failure. The scan may have caused the service to freeze or stop running. An administrator may have stopped this particular service during the scanning process. A network failure may have occurred.

Risk factor : None";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check if ports are still open";
 script_summary(english:summary["english"]);
 
 script_category(ACT_END);


 script_copyright(english:"This script is Copyright (C) 2002 Michel Arboi");
 family["english"] = "Misc.";
 script_family(english:family["english"]);

 script_dependencie("find_service1.nasl");
 exit(0);
}

#
# Do not do a false positive if netstat or the snmp 
# port scanners have been used.
#
if ( get_kb_item("Host/scanners/netstat") || 
     get_kb_item("Host/scanners/snmp_scanner") ) exit(0); 

ports = get_kb_list("Ports/tcp/*");
if(isnull(ports))exit(0);

number_of_ports = 0;
closed_ports = 0;

myreport = string("The following ports were open at the beginning of the scan but are now closed:\n\n");

foreach port (keys(ports))
{
   number_of_ports ++;
   port = int(port - "Ports/tcp/");
   if ( port == 139 || port == 445 ) continue;
   then = unixtime();
   s = open_sock_tcp(port);
   now = unixtime();
   if (! s)
   {
    	myreport += string("Port "); myreport += port; myreport += string(" was detected as being open but is now ");
	if ( now - then < 4 ) myreport += string("closed\n");
	else myreport += string("unresponsive\n");
	closed_ports++;
   }
   else
   {
    	close(s);
   }
}


if( number_of_ports == 0 || closed_ports == 0) { exit(0); }
else {

myreport += string("\nThis might be an availability problem related which might be due to the following reasons :\n\n");
myreport += string("- The remote host is now down, either because a user turned it off during the scan\n");

if(safe_checks() == 0) myreport += string("- A selected denial of service was effective against this host\n");

myreport += string("- A network outage has been experienced during the scan, and the remote 
network cannot be reached from the Vulnerability Scanner any more\n");

myreport += string("- This Vulnerability Scanner has been blacklisted by the system administrator
or by automatic intrusion detection/prevention systems which have detected the 
vulnerability assessment.\n\n");

myreport += string("In any case, the audit of the remote host might be incomplete and may need to
be done again\n");

 security_note(port:0, data:myreport); 

}




