#
# This script was written by Michel Arboi <mikhail@nessus.org>
# GPL...
#

if(description)
{
 script_id(20162);
 script_version ("$Revision: 1.3 $");
 script_name(english: "Cheops NG cleartext authentication");
 
 desc = "
Synopsis :

The remote Cheops NG agent is affected by an information disclosure
issue. 

Description :

A Cheops NG agent is running on this port.  Users with a valid account
on the remote host can connect to this service and use it to map your
network, portscan machines and identify running services. 

The agent is configured to allow unencrypted connections, which may
allow passwords, that are transmitted in cleartext, to be sniffed. 

In addition, it is possible to brute force login/passwords on the
remote host using this agent. 

Solution:

Configure Cheops to run on top of SSL or block this port from outside
communication if you want to further restrict the use of Cheops. 

Risk factor :

Medium / CVSS Base Score : 4.3
(CVSS2#AV:N/AC:M/Au:N/C:P/I:N/A:N)";

 script_description(english:desc);
 script_summary(english: "Cheops NG agent uses clear text passwords");
 script_category(ACT_GATHER_INFO);
 script_copyright(english:"This script is Copyright (C) 2005-2008 Michel Arboi");
 script_family(english: "Service detection");
 script_dependencie("cheopsNG_detect.nasl");
 script_require_keys("cheopsNG/password");
 exit(0);
}

port = get_kb_item("cheopsNG/password");
if (port && get_port_transport(port) == ENCAPS_IP ) security_warning(port);
