#
# (C) Tenable Network Security
#


if(description)
{
 script_id(16201);
 script_cve_id(
  "CVE-2004-1432",
  "CVE-2004-1433",
  "CVE-2004-1434",
  "CVE-2004-1435",
  "CVE-2004-1436"
 );
 script_bugtraq_id(10768);
 script_xref(name:"OSVDB", value:"8149");
 script_xref(name:"OSVDB", value:"8150");
 script_xref(name:"OSVDB", value:"8151");
 script_xref(name:"OSVDB", value:"8152");
 script_xref(name:"OSVDB", value:"8153");
 script_xref(name:"OSVDB", value:"8154");
 script_xref(name:"OSVDB", value:"8155");
 script_version("$Revision: 1.3 $");

 name["english"] = "CISCO ONS Multiple Vulnerabilities";

 script_name(english:name["english"]);

 desc["english"] = "
Synopsis :

The remote network device is affected by multiple vulnerabilities.

Description :

The remote Cisco ONS platform is vulnerable to various vulnerabilities
that may allow a remote attacker to cause a denial of service in the
remote control cards or to bypass authentication on the remote device. 

See also :

http://www.cisco.com/warp/public/707/cisco-sa-20040721-ons.shtml

Solution :

Apply the appropriate update as referenced in the vendor advisory
above. 

Risk Factor : 

High / CVSS Base Score : 8
(AV:R/AC:H/Au:NR/C:C/I:C/A:C/B:N)";
 script_description(english:desc["english"]);

 summary["english"] = "Uses SNMP to determine if a flaw is present";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"This script is (C) 2005-2007 Tenable Network Security");

 script_family(english:"CISCO");

 script_dependencie("snmp_sysDesc.nasl");
 script_require_keys("SNMP/sysDesc");
 exit(0);
}


sysDesc = get_kb_item("SNMP/sysDesc"); 
if ( ! sysDesc ) exit(0);

if ("Cisco ONS" >!< sysDesc ) exit(0);

if ( egrep(pattern:"Cisco ONS 15327.*", string:sysDesc) ) 
{
 version = chomp(ereg_replace(pattern:".*Cisco ONS 15327.* ([0-9.]*)-.*", string:sysDesc, replace:"\1"));
 int_version = eregmatch(pattern:"^([0-9]+)\.([0-9])([0-9])$", string:version);
 if ( int(int_version[1]) <= 3 ) security_hole(port);
 else if ( int(int_version[1]) == 4 && int(int_version[2]) == 0 && int(int_version[3]) <= 2) security_hole(port);
 else if ( int(int_version[1]) == 4 && int(int_version[2]) == 1 && int(int_version[3]) <= 3) security_hole(port);
 else if ( int(int_version[1]) == 4 && int(int_version[2]) == 6 && int(int_version[3]) <= 1) security_hole(port);
}
else if ( egrep(pattern:"Cisco ONS 15454.*", string:sysDesc) ) 
{
 version = chomp(ereg_replace(pattern:".*Cisco ONS 15454.* ([0-9.]*)-.*", string:sysDesc, replace:"\1"));
 int_version = eregmatch(pattern:"^([0-9]+)\.([0-9])([0-9])$", string:version);
 if ( int(int_version[1]) <= 3 ) security_hole(port);
 else if ( int(int_version[1]) == 4 && int(int_version[2]) == 0 && int(int_version[3]) <= 2) security_hole(port);
 else if ( int(int_version[1]) == 4 && int(int_version[2]) == 1 && int(int_version[3]) <= 3) security_hole(port);
 else if ( int(int_version[1]) == 4 && int(int_version[2]) == 5 ) security_hole(port);
 else if ( int(int_version[1]) == 4 && int(int_version[2]) == 6 && int(int_version[3]) <= 1) security_hole(port);
}
else if ( egrep(pattern:"Cisco ONS 15600.*", string:sysDesc) ) 
{
 version = chomp(ereg_replace(pattern:".*Cisco ONS 15600.* ([0-9.]*)-.*", string:sysDesc, replace:"\1"));
 int_version = eregmatch(pattern:"^([0-9]+)\.([0-9])([0-9])$", string:version);
 if ( int(int_version[1]) <= 1 ) security_hole(port);
}
