#
# This script is (C) Renaud Deraison
#
#
#  Date: Fri, 14 Mar 2003 18:42:02 -0800
#  To: bugtraq@securityfocus.com
#  Subject: @(#)Mordred Security Labs - RSA ClearTrust Cross Site Scripting issues 
#  From: sir.mordred@hushmail.com



if(description)
{
 script_id(11399);
 script_bugtraq_id(7108);
 script_version ("$Revision: 1.17 $");
 
 name["english"] = "ClearTrust XSS";
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote web server is prone to a cross-site scripting attack. 

Description :

The remote ClearTrust server is vulnerable to a cross-site scripting
attack that can be exploited using specially-crafted calls to its
'ct_logon.asp' or 'ct_logon.jsp' scripts. 

See also :

http://archives.neohapsis.com/archives/bugtraq/2003-03/0224.html

Solution : 

Unknown at this time

Risk factor :

Medium / CVSS Base Score : 4.3
(CVSS2#AV:N/AC:M/Au:N/C:N/I:P/A:N)";
 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for ClearTrust XSS";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 2003 Renaud Deraison");
 family["english"] = "CGI abuses : XSS";
 script_family(english:family["english"]);

 script_dependencie("find_service1.nasl", "http_version.nasl", "cross_site_scripting.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 
 exit(0);
}

#
# The script code starts here
#
include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);
if ( ! can_host_asp(port:port) ) exit(0);

if(get_kb_item(string("www/", port, "/generic_xss"))) exit(0);

foreach dir (make_list(cgi_dirs()))
{
 foreach script (make_list("ct_logon.asp", "ct_logon.jsp"))
 {
  exploit = string(
   dir, "/cleartrust/", script, "?",
   "CTLoginErrorMsg=<script>alert(1)</script>"
  );
  req = http_get(item:exploit, port:port);
  res = http_keepalive_send_recv(port:port, data:req);
  if ( res == NULL ) exit (0);
  if(!ereg(pattern:"^HTTP/[0-9]\.[0-9] 200 ", string:res))exit(0);

  if("<script>alert(1)</script>" >< res )
  {
   if (report_verbosity)
   {
    extra = string(
     "\n",
     "Nessus was able to exploit this issue using the following request :\n",
     "\n",
     exploit
    );
    security_warning(port:port, extra:extra);
   }
   else security_warning(port);
   exit(0);
  }
 }
}
