#
# (C) Tenable Network Security
#


if (description)
{
  script_id(10815);
  script_version("$Revision: 1.49 $");

  script_cve_id(
    "CVE-2002-1060", 
    "CVE-2003-1543", 
    "CVE-2005-2453", 
    "CVE-2006-1681"
  );
  script_bugtraq_id(5305, 7344, 7353, 8037, 14473, 17408);
  script_xref(name:"OSVDB", value:"4989");
  script_xref(name:"OSVDB", value:"18525");
  script_xref(name:"OSVDB", value:"24469");

  name["english"] = "Web Server Generic Cross-Site Scripting Vulnerability";
  script_name(english:name["english"]);
 
  desc["english"] = "
Synopsis :

The remote web server is prone to cross-site scripting attacks. 

Description :

The remote host is running a web server that fails to adequately
sanitize request strings of malicious Javascript.  By leveraging this
issue, an attacker may be able to cause arbitrary HTML and script code
to be executed in a user's browser within the security context of the
affected site. 

Solution : 

Contact the vendor for a patch or upgrade.

Risk factor :

Medium / CVSS Base Score : 4.3
(CVSS2#AV:N/AC:M/Au:N/C:N/I:P/A:N)";
  script_description(english:desc["english"]);
 
  summary["english"] = "Checks for generic cross-site scripting vulnerability in a web server";
  script_summary(english:summary["english"]);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"CGI abuses : XSS");

  script_copyright(english:"This script is Copyright (C) 2005-2008 Tenable Network Security");

  script_dependencie("http_version.nasl");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");
include("global_settings.inc");
include("misc_func.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);


file = rand_str(charset:"abcdefghijklmnopqrstuvwxyz0123456789_");
exts = make_list(
  "",
  "asp",
  "cfm",
  "html",
  "jsp",
  "php",
  "php3",
  "phtml",
  "shtml"
);
exploits = make_list(
  # nb: while this isn't valid Javascript, it will tell us
  #     if malicious script tags are output unfiltered.
  string("<script>", SCRIPT_NAME, "</script>"),
  string('<IMG SRC="javascript:alert(', SCRIPT_NAME, ');">')
);



foreach ext (exts)
{
  foreach exploit (exploits)
  {
    if (" " >< exploit) enc_exploit = str_replace(find:" ", replace:"%20", string:exploit);
    else enc_exploit = exploit;

    if (ext) urls = make_list(string("/", file, ".", ext, "?", enc_exploit));
    else
      urls = make_list(
        # nb: does server check "filenames" for Javascript?
        string("/", enc_exploit),
        enc_exploit,
        # nb: how about just the request string?
        string("/?", enc_exploit)
      );

    foreach url (urls)
    {
      # Try to exploit the flaw.
      req = http_get(item:url, port:port);
      res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
      if (res == NULL) exit(0);

      if (exploit >< res)
      {
        set_kb_item(name:string("www/", port, "/generic_xss"), value:TRUE);

        if (report_verbosity)
        {
          report = string(
            "\n",
            "The request string used to detect this flaw was :\n",
            "\n",
            "  ", url, "\n",
            "\n",
            "To replicate this manually, try replacing '", SCRIPT_NAME, "'\n",
            "above with either 'document.cookie' or a number such as '123'.\n"
          );
          security_warning(port:port, extra:report);
        }
        else security_warning(port);

        exit(0);
      }
    }
  }
}
