#
# (C) Tenable Network Security, Inc.
#


  desc = "
Synopsis :

The remote printer service is affected by a buffer overflow
vulnerability. 

Description :

According to its banner, the version of CUPS installed on the remote
host contains a stack-based integer overflow in 'asn1_get_string' in
'backend/snmp.c'.  Provided the SNMP backend is configured in CUPS
(true by default in CUPS 1.2 but not 1.3), an attacker may be able to
leverage this issue using specially-crafted SNMP responses with
negative lengths to overflow a buffer and execute arbitrary code on
the affected system. 

See also :

http://www.cups.org/str.php?L2589
http://www.cups.org/articles.php?L519

Solution :

Upgrade to CUPS version 1.3.5 or later. 

Risk factor : 

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";


if (description)
{
  script_id(29727);
  script_version("$Revision: 1.5 $");

  script_cve_id("CVE-2007-5849");
  script_bugtraq_id(26917);
  script_xref(name:"OSVDB", value:"40719");

  script_name(english:"CUPS SNMP Backend Buffer Overflow Vulnerability");
  script_summary(english:"Checks CUPS server version");
 
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Misc.");
 
  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_require_keys("www/cups");
  script_require_ports("Services/www", 631);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");


# nb: banner checks of open-source software are prone to false-
#     positives so only run the check if reporting is paranoid.
if (report_paranoia < 2) exit(0);


if (!get_kb_item("www/cups")) exit(0);


port = get_http_port(default:631);
if (!get_port_state(port)) exit(0);


# Check the version in the banner.
banner = get_http_banner(port:port);
if (!banner) exit(0);

banner = strstr(banner, "Server:");
banner = banner - strstr(banner, '\r\n');
if ("CUPS/" >< banner)
{
  version = strstr(banner, "CUPS/") - "CUPS/";
  # nb: STR #2589 says 1.1 is not affected.
  if (version =~ "^1\.(2|3\.[0-4])($|[^0-9])")
  {
    report = string(
      desc,
      "\n\n",
      "Plugin output :\n",
      "\n",
      "The remote CUPS server returned the following banner :\n",
      "\n",
      "  ", banner, "\n"
    );
    security_hole(port:port, data:report);
  }
}
