#
# (C) Tenable Network Security
#

 desc = "
Synopsis :

The remote web server contains a CGI script that allows arbitrary
command execution. 

Description :

The remote host is running K-COLLECT csv-database, a web application
written in perl. 

The remote version of this software fails to sanitize user input to
the 'file' parameter of the 'csv_db.cgi' script before using it to run
a shell command.  An unauthenticated can exploit this issue to execute
arbitrary commands on the remote host subject to the privileges under
which the web server operates. 

Solution :

Remove this script.

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";


if(description)
{
 script_id(18563);
 script_version("$Revision: 1.4 $");

 script_bugtraq_id(14059);
  
 name["english"] = "K-COLLECT CSV-DB CSV_DB.CGI Remote Command Execution Vulnerability";
 script_name(english:name["english"]);
 
 script_description(english:desc);
 
 summary["english"] = "Checks for K-COLLECT CSV-DB remote command execution flaw";
 
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 
 script_copyright(english:"This script is Copyright (C) 2005-2008 Tenable Network Security");
 family["english"] = "CGI abuses";
 script_family(english:family["english"]);
 script_dependencies("http_version.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");

http_check_remote_code (
			check_request:"/csv_db.cgi?file=|id|",
			extra_check:"www\.k-collect\.net/ target=_top>csv-Database Ver.* by K-COLLECT</a></div>",
			check_result:"uid=[0-9]+.*gid=[0-9]+.*",
			command:"id",
			description:desc
			);
