#
# (C) Tenable Network Security
#


if (description)
{
  script_id(24699);
  script_version("$Revision: 1.7 $");

  script_cve_id("CVE-2007-1086", "CVE-2007-1087", "CVE-2007-1088", "CVE-2007-1228");
  script_bugtraq_id(22677, 22729);
  script_xref(name:"OSVDB", value:"34021");

  script_name(english:"DB2 < 9 Fix Pack 2");
  script_summary(english:"Checks DB2 signature");

  desc = "
Synopsis :

The remote database server is affected by multiple issues.

Description :

According to its version, the installation of DB2 on the remote host
allows unsafe access to several setuid-root binaries.  A local user
may be able to leverage this to crash the affected database server or
possibly even gain root-level access. 

In addition, the fenced userid may be able to access directories
without proper authorization. 

See also : 

http://labs.idefense.com/intelligence/vulnerabilities/display.php?id=480
http://labs.idefense.com/intelligence/vulnerabilities/display.php?id=481
http://archives.neohapsis.com/archives/fulldisclosure/2007-02/0521.html
http://archives.neohapsis.com/archives/fulldisclosure/2007-02/0523.html
http://www-1.ibm.com/support/docview.wss?uid=swg21255745
http://www-1.ibm.com/support/docview.wss?uid=swg21255747
http://www-1.ibm.com/support/docview.wss?uid=swg1IY86711

Solution :

Apply DB2 Version 9 Fix Pack 2 or later. 

Risk factor : 

High / CVSS Base Score : 7.2
(CVSS2#AV:L/AC:L/Au:N/C:C/I:C/A:C)";
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Databases");
 
  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security");
 
  script_dependencies("db2_das_detect.nasl");
  script_require_ports("Services/db2das", 523);

  exit(0);
}


port = get_kb_item("Services/db2das");
if (!port) port = 523;
if (!get_port_state(port)) exit(0);


# Make sure the port is really open.
soc = open_sock_tcp(port);
if (!soc) exit(0);
close(soc);


function is_level_older(lvl, base, min)
{
  if (isnull(lvl) || isnull(base)) return NULL;

  local_var i, v1, v2, vmin;

  v1 = split(lvl, sep:'.', keep:0);
  v2 = split(base, sep:'.', keep:0);
  if (isnull(min)) vmin = make_list(0,0,0,0);
  else vmin = split(min, sep:'.', keep:0);

  v1 = make_list(int(v1[0]), int(v1[1]), int(v1[2]), int(v1[3]));
  v2 = make_list(int(v2[0]), int(v2[1]), int(v2[2]), int(v2[3]));
  vmin = make_list(int(vmin[0]), int(vmin[1]), int(vmin[2]), int(vmin[3]));

  for (i=0; i<max_index(v1); i++)
    if (v1[i] < v2[i])
    {
      if (v1[i] < vmin[i]) return FALSE;
      else return TRUE;
    }
    else if (v1[i] > v2[i]) return FALSE;

  return FALSE;
}


platform = get_kb_item("DB2/" + port + "/Platform");
level = get_kb_item("DB2/" + port + "/Level");
if (platform && level)
{
  if (
    # Windows, x86
    #   nb: unaffected by IY94817 and IY94833.
    (platform == 5 && is_level_older(lvl:level, base:"9.1.100.129", min:"9.0.0.0")) ||
    # Linux, x86, 2.6 kernel
    (platform == 18 && is_level_older(lvl:level, base:"9.1.0.2", min:"9.0.0.0"))
  ) security_hole(port);
}
