# This script was automatically generated from the dsa-1201
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Several remote vulnerabilities have been discovered in the Ethereal network
scanner. The Common Vulnerabilities and Exposures project identifies the
following problems:
    It was discovered that the MIME multipart dissector is vulnerable to
    denial of service caused by an off-by-one overflow.
    It was discovered that the XOT dissector is vulnerable to denial
    of service caused by memory corruption.
For the stable distribution (sarge) these problems have been fixed in
version 0.10.10-2sarge9. Due to technical problems with the security
buildd infrastructure this update lacks builds for the hppa and sparc
architecture. They will be released as soon as the problems are resolved.
For the unstable distribution (sid) these problems will be fixed soon.
We recommend that you upgrade your ethereal packages.


Solution : http://www.debian.org/security/2006/dsa-1201
Risk factor : High';

if (description) {
 script_id(22931);
 script_version("$Revision: 1.1 $");
 script_xref(name: "DSA", value: "1201");
 script_cve_id("CVE-2006-4574", "CVE-2006-4805");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2006 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1201] DSA-1201-1 ethereal");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1201-1 ethereal");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'ethereal', release: '3.1', reference: '0.10.10-2sarge9')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ethereal is vulnerable in Debian 3.1.\nUpgrade to ethereal_0.10.10-2sarge9\n');
}
if (deb_check(prefix: 'ethereal-common', release: '3.1', reference: '0.10.10-2sarge9')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ethereal-common is vulnerable in Debian 3.1.\nUpgrade to ethereal-common_0.10.10-2sarge9\n');
}
if (deb_check(prefix: 'ethereal-dev', release: '3.1', reference: '0.10.10-2sarge9')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ethereal-dev is vulnerable in Debian 3.1.\nUpgrade to ethereal-dev_0.10.10-2sarge9\n');
}
if (deb_check(prefix: 'tethereal', release: '3.1', reference: '0.10.10-2sarge9')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package tethereal is vulnerable in Debian 3.1.\nUpgrade to tethereal_0.10.10-2sarge9\n');
}
if (deb_check(prefix: 'ethereal', release: '3.1', reference: '0.10.10-2sarge9')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ethereal is vulnerable in Debian sarge.\nUpgrade to ethereal_0.10.10-2sarge9\n');
}
if (w) { security_hole(port: 0, data: desc); }
