# This script was automatically generated from the dsa-1208
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Several remote vulnerabilities have been discovered in the Bugzilla
bug tracking system, which may lead to the execution of arbitrary code.
The Common Vulnerabilities and Exposures project identifies the following
problems:
    Javier Fernndez-Sanguino Pea discovered that insecure temporary
    file usage may lead to denial of service through a symlink attack.
    Several cross-site scripting vulnerabilities may lead to injection
    of arbitrary web script code.
For the stable distribution (sarge) these problems have been fixed in
version 2.16.7-7sarge2.
For the upcoming stable distribution (etch) these problems have been
fixed in version 2.22.1-1.
For the unstable distribution (sid) these problems have been fixed in
version 2.22.1-1.
We recommend that you upgrade your bugzilla packages.


Solution : http://www.debian.org/security/2006/dsa-1208
Risk factor : High';

if (description) {
 script_id(23657);
 script_version("$Revision: 1.3 $");
 script_xref(name: "DSA", value: "1208");
 script_cve_id("CVE-2005-4534", "CVE-2006-5453");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1208] DSA-1208-1 bugzilla");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1208-1 bugzilla");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'bugzilla', release: '3.1', reference: '2.16.7-7sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package bugzilla is vulnerable in Debian 3.1.\nUpgrade to bugzilla_2.16.7-7sarge2\n');
}
if (deb_check(prefix: 'bugzilla-doc', release: '3.1', reference: '2.16.7-7sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package bugzilla-doc is vulnerable in Debian 3.1.\nUpgrade to bugzilla-doc_2.16.7-7sarge2\n');
}
if (deb_check(prefix: 'bugzilla', release: '4.0', reference: '2.22.1-1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package bugzilla is vulnerable in Debian etch.\nUpgrade to bugzilla_2.22.1-1\n');
}
if (deb_check(prefix: 'bugzilla', release: '3.1', reference: '2.16.7-7sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package bugzilla is vulnerable in Debian sarge.\nUpgrade to bugzilla_2.16.7-7sarge2\n');
}
if (w) { security_hole(port: 0, data: desc); }
