# This script was automatically generated from the dsa-1211
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
It was discovered that malformed TCP packets may lead to denial of service
and possibly the execution of arbitrary code if the PowerDNS nameserver
acts as a recursive nameserver.
For the stable distribution (sarge) this problem has been fixed in
version 2.9.17-13sarge3.
For the upcoming stable distribution (etch) this problem has been fixed
in version 3.1.4-1 of pdns-recursor.
For the unstable distribution (sid) this problem has been fixed in
version 3.1.4-1 of pdns-recursor.
We recommend that you upgrade your PowerDNS packages.


Solution : http://www.debian.org/security/2006/dsa-1211
Risk factor : High';

if (description) {
 script_id(23660);
 script_version("$Revision: 1.3 $");
 script_xref(name: "DSA", value: "1211");
 script_cve_id("CVE-2006-4251");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1211] DSA-1211-1 pdns");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1211-1 pdns");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'pdns', release: '3.1', reference: '2.9.17-13sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package pdns is vulnerable in Debian 3.1.\nUpgrade to pdns_2.9.17-13sarge3\n');
}
if (deb_check(prefix: 'pdns-backend-geo', release: '3.1', reference: '2.9.17-13sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package pdns-backend-geo is vulnerable in Debian 3.1.\nUpgrade to pdns-backend-geo_2.9.17-13sarge3\n');
}
if (deb_check(prefix: 'pdns-backend-ldap', release: '3.1', reference: '2.9.17-13sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package pdns-backend-ldap is vulnerable in Debian 3.1.\nUpgrade to pdns-backend-ldap_2.9.17-13sarge3\n');
}
if (deb_check(prefix: 'pdns-backend-mysql', release: '3.1', reference: '2.9.17-13sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package pdns-backend-mysql is vulnerable in Debian 3.1.\nUpgrade to pdns-backend-mysql_2.9.17-13sarge3\n');
}
if (deb_check(prefix: 'pdns-backend-pgsql', release: '3.1', reference: '2.9.17-13sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package pdns-backend-pgsql is vulnerable in Debian 3.1.\nUpgrade to pdns-backend-pgsql_2.9.17-13sarge3\n');
}
if (deb_check(prefix: 'pdns-backend-pipe', release: '3.1', reference: '2.9.17-13sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package pdns-backend-pipe is vulnerable in Debian 3.1.\nUpgrade to pdns-backend-pipe_2.9.17-13sarge3\n');
}
if (deb_check(prefix: 'pdns-backend-sqlite', release: '3.1', reference: '2.9.17-13sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package pdns-backend-sqlite is vulnerable in Debian 3.1.\nUpgrade to pdns-backend-sqlite_2.9.17-13sarge3\n');
}
if (deb_check(prefix: 'pdns-doc', release: '3.1', reference: '2.9.17-13sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package pdns-doc is vulnerable in Debian 3.1.\nUpgrade to pdns-doc_2.9.17-13sarge3\n');
}
if (deb_check(prefix: 'pdns-recursor', release: '3.1', reference: '2.9.17-13sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package pdns-recursor is vulnerable in Debian 3.1.\nUpgrade to pdns-recursor_2.9.17-13sarge3\n');
}
if (deb_check(prefix: 'pdns-server', release: '3.1', reference: '2.9.17-13sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package pdns-server is vulnerable in Debian 3.1.\nUpgrade to pdns-server_2.9.17-13sarge3\n');
}
if (deb_check(prefix: 'pdns', release: '4.0', reference: '3.1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package pdns is vulnerable in Debian etch.\nUpgrade to pdns_3.1\n');
}
if (deb_check(prefix: 'pdns', release: '3.1', reference: '2.9.17-13sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package pdns is vulnerable in Debian sarge.\nUpgrade to pdns_2.9.17-13sarge3\n');
}
if (w) { security_hole(port: 0, data: desc); }
