# This script was automatically generated from the dsa-1218
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
It was discovered that the proftpd FTP daemon performs insufficient
validation of FTP command buffer size limits, which may lead to denial of
service.
For the stable distribution (sarge) this problem has been fixed in
version 1.2.10-15sarge2.
For the unstable distribution (sid) this problem has been fixed in
version 1.3.0-13 of the proftpd-dfsg package.
We recommend that you upgrade your proftpd package.


Solution : http://www.debian.org/security/2006/dsa-1218
Risk factor : High';

if (description) {
 script_id(23704);
 script_version("$Revision: 1.3 $");
 script_xref(name: "DSA", value: "1218");
 script_cve_id("CVE-2006-6171");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1218] DSA-1218-1 proftpd");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1218-1 proftpd");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'proftpd', release: '3.1', reference: '1.2.10-15sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package proftpd is vulnerable in Debian 3.1.\nUpgrade to proftpd_1.2.10-15sarge2\n');
}
if (deb_check(prefix: 'proftpd-common', release: '3.1', reference: '1.2.10-15sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package proftpd-common is vulnerable in Debian 3.1.\nUpgrade to proftpd-common_1.2.10-15sarge2\n');
}
if (deb_check(prefix: 'proftpd-doc', release: '3.1', reference: '1.2.10-15sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package proftpd-doc is vulnerable in Debian 3.1.\nUpgrade to proftpd-doc_1.2.10-15sarge2\n');
}
if (deb_check(prefix: 'proftpd-ldap', release: '3.1', reference: '1.2.10-15sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package proftpd-ldap is vulnerable in Debian 3.1.\nUpgrade to proftpd-ldap_1.2.10-15sarge2\n');
}
if (deb_check(prefix: 'proftpd-mysql', release: '3.1', reference: '1.2.10-15sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package proftpd-mysql is vulnerable in Debian 3.1.\nUpgrade to proftpd-mysql_1.2.10-15sarge2\n');
}
if (deb_check(prefix: 'proftpd-pgsql', release: '3.1', reference: '1.2.10-15sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package proftpd-pgsql is vulnerable in Debian 3.1.\nUpgrade to proftpd-pgsql_1.2.10-15sarge2\n');
}
if (deb_check(prefix: 'proftpd', release: '3.1', reference: '1.2.10-15sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package proftpd is vulnerable in Debian sarge.\nUpgrade to proftpd_1.2.10-15sarge2\n');
}
if (w) { security_hole(port: 0, data: desc); }
