# This script was automatically generated from the dsa-1231
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Several remote vulnerabilities have been discovered in the GNU privacy guard,
a free PGP replacement, which may lead to the execution of arbitrary code.
The Common Vulnerabilities and Exposures project identifies the following
problems:
    Werner Koch discovered that a buffer overflow in a sanitising function
    may lead to execution of arbitrary code when running gnupg
    interactively.
    Tavis Ormandy discovered that parsing a carefully crafted OpenPGP
    packet may lead to the execution of arbitrary code, as a function
    pointer of an internal structure may be controlled through the
    decryption routines.
For the stable distribution (sarge) these problems have been fixed in
version 1.4.1-1.sarge6.
For the upcoming stable distribution (etch) these problems have been
fixed in version 1.4.6-1.
For the unstable distribution (sid) these problems have been fixed in
version 1.4.6-1.
We recommend that you upgrade your gnupg packages.


Solution : http://www.debian.org/security/2006/dsa-1231
Risk factor : High';

if (description) {
 script_id(23792);
 script_version("$Revision: 1.4 $");
 script_xref(name: "DSA", value: "1231");
 script_cve_id("CVE-2006-6169", "CVE-2006-6235");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1231] DSA-1231-1 gnupg");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1231-1 gnupg");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'gnupg', release: '3.1', reference: '1.4.1-1.sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package gnupg is vulnerable in Debian 3.1.\nUpgrade to gnupg_1.4.1-1.sarge6\n');
}
if (deb_check(prefix: 'gnupg', release: '4.0', reference: '1.4.6-1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package gnupg is vulnerable in Debian etch.\nUpgrade to gnupg_1.4.6-1\n');
}
if (deb_check(prefix: 'gnupg', release: '3.1', reference: '1.4.1-1.sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package gnupg is vulnerable in Debian sarge.\nUpgrade to gnupg_1.4.1-1.sarge6\n');
}
if (w) { security_hole(port: 0, data: desc); }
