# This script was automatically generated from the dsa-1239
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Several remote vulnerabilities have been discovered in SQL Ledger, a web
based double-entry accounting program, which may lead to the execution
of arbitrary code. The Common Vulnerabilities and Exposures project
identifies the following problems:
    Chris Travers discovered that the session management can be tricked
    into hijacking existing sessions.
    Chris Travers discovered that directory traversal vulnerabilities
    can be exploited to execute arbitrary Perl code.
    It was discovered that missing input sanitising allows execution of
    arbitrary Perl code.
For the stable distribution (sarge) these problems have been fixed in
version 2.4.7-2sarge1.
For the upcoming stable distribution (etch) these problems have been
fixed in version 2.6.21-1.
For the unstable distribution (sid) these problems have been fixed in
version 2.6.21-1.
We recommend that you upgrade your sql-ledger packages.


Solution : http://www.debian.org/security/2006/dsa-1239
Risk factor : High';

if (description) {
 script_id(23913);
 script_version("$Revision: 1.3 $");
 script_xref(name: "DSA", value: "1239");
 script_cve_id("CVE-2006-4244", "CVE-2006-4731", "CVE-2006-5872");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1239] DSA-1239-1 sql-ledger");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1239-1 sql-ledger");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'sql-ledger', release: '3.1', reference: '2.4.7-2sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package sql-ledger is vulnerable in Debian 3.1.\nUpgrade to sql-ledger_2.4.7-2sarge1\n');
}
if (deb_check(prefix: 'sql-ledger', release: '4.0', reference: '2.6.21-1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package sql-ledger is vulnerable in Debian etch.\nUpgrade to sql-ledger_2.6.21-1\n');
}
if (deb_check(prefix: 'sql-ledger', release: '3.1', reference: '2.4.7-2sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package sql-ledger is vulnerable in Debian sarge.\nUpgrade to sql-ledger_2.4.7-2sarge1\n');
}
if (w) { security_hole(port: 0, data: desc); }
