# This script was automatically generated from the dsa-1240
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Teemu Salmela discovered that the links2 character mode web browser
performs insufficient sanitising of smb:// URIs, which might lead to the
execution of arbitrary shell commands.
For the stable distribution (sarge) this problem has been fixed in
version 2.1pre16-1sarge1.
For the upcoming stable distribution (etch) this problem has been
fixed in version 2.1pre26-1.
For the unstable distribution (sid) this problem has been fixed in
version 2.1pre26-1.
We recommend that you upgrade your links2 package.


Solution : http://www.debian.org/security/2006/dsa-1240
Risk factor : High';

if (description) {
 script_id(23945);
 script_version("$Revision: 1.3 $");
 script_xref(name: "DSA", value: "1240");
 script_cve_id("CVE-2006-5925");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1240] DSA-1240-1 links2");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1240-1 links2");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'links2', release: '3.1', reference: '2.1pre16-1sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package links2 is vulnerable in Debian 3.1.\nUpgrade to links2_2.1pre16-1sarge1\n');
}
if (deb_check(prefix: 'links2', release: '4.0', reference: '2.1pre26-1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package links2 is vulnerable in Debian etch.\nUpgrade to links2_2.1pre26-1\n');
}
if (deb_check(prefix: 'links2', release: '3.1', reference: '2.1pre16-1sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package links2 is vulnerable in Debian sarge.\nUpgrade to links2_2.1pre16-1sarge1\n');
}
if (w) { security_hole(port: 0, data: desc); }
