# This script was automatically generated from the dsa-1241
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Martijn Brinkers discovered cross-site scripting vulnerabilities in
the mailto parameter of webmail.php, the session and delete_draft
parameters of compose.php and through a shortcoming in the magicHTML
filter. An attacker could abuse these to execute malicious JavaScript in
the user\'s webmail session. 
Also, a workaround was made for Internet Explorer <= 5: IE will attempt
to guess the MIME type of attachments based on content, not the MIME 
header sent. Attachments could fake to be a \'harmless\' JPEG, while they
were in fact HTML that Internet Explorer would render.
For the stable distribution (sarge) these problems have been fixed in
version 2:1.4.4-10.
For the upcoming stable distribution (etch) these problems have been fixed
in version 2:1.4.9a-1.
For the unstable distribution (sid) these problems have been fixed in
version 2:1.4.9a-1.
We recommend that you upgrade your squirrelmail package.


Solution : http://www.debian.org/security/2006/dsa-1241
Risk factor : High';

if (description) {
 script_id(23946);
 script_version("$Revision: 1.4 $");
 script_xref(name: "DSA", value: "1241");
 script_cve_id("CVE-2006-6142");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1241] DSA-1241-1 squirrelmail");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1241-1 squirrelmail");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'squirrelmail', release: '3.1', reference: '1.4.4-10')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package squirrelmail is vulnerable in Debian 3.1.\nUpgrade to squirrelmail_1.4.4-10\n');
}
if (deb_check(prefix: 'squirrelmail', release: '4.0', reference: '1.4.9a-1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package squirrelmail is vulnerable in Debian etch.\nUpgrade to squirrelmail_1.4.9a-1\n');
}
if (deb_check(prefix: 'squirrelmail', release: '3.1', reference: '1.4.4-10')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package squirrelmail is vulnerable in Debian sarge.\nUpgrade to squirrelmail_1.4.4-10\n');
}
if (w) { security_hole(port: 0, data: desc); }
