# This script was automatically generated from the dsa-1242
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Several remote vulnerabilities have been discovered in elog, a web-based
electronic logbook, which may lead to the execution of arbitrary code.
The Common Vulnerabilities and Exposures project identifies the following
problems:
    Tilman Koschnick discovered that log entry editing in HTML is vulnerable
    to cross-site scripting. This update disables the vulnerable code.
    Ulf Hrnhammar of the Debian Security Audit Project discovered several
    format string vulnerabilities in elog, which may lead to execution of
    arbitrary code.
    Ulf Hrnhammar of the Debian Security Audit Project discovered 
    cross-site scripting vulnerabilities in the creation of new logbook
    entries.
    Jayesh KS and Arun Kethipelly of OS2A discovered that elog performs
    insufficient error handling in config file parsing, which may lead to
    denial of service through a NULL pointer dereference.
For the stable distribution (sarge) these problems have been fixed in
version 2.5.7+r1558-4+sarge3.
The upcoming stable distribution (etch) will no longer include elog.
For the unstable distribution (sid) these problems have been fixed in
version 2.6.2+r1754-1.
We recommend that you upgrade your elog package.


Solution : http://www.debian.org/security/2006/dsa-1242
Risk factor : High';

if (description) {
 script_id(23947);
 script_version("$Revision: 1.3 $");
 script_xref(name: "DSA", value: "1242");
 script_cve_id("CVE-2006-5063", "CVE-2006-5790", "CVE-2006-5791", "CVE-2006-6318");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1242] DSA-1242-1 elog");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1242-1 elog");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'elog', release: '3.1', reference: '2.5.7+r1558-4+sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package elog is vulnerable in Debian 3.1.\nUpgrade to elog_2.5.7+r1558-4+sarge3\n');
}
if (deb_check(prefix: 'elog', release: '3.1', reference: '2.5.7+r1558-4+sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package elog is vulnerable in Debian sarge.\nUpgrade to elog_2.5.7+r1558-4+sarge3\n');
}
if (w) { security_hole(port: 0, data: desc); }
