# This script was automatically generated from the dsa-1244
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
It was discovered that the Xine multimedia library performs insufficient
sanitising of Real streams, which might lead to the execution of arbitrary
code through a buffer overflow.
For the stable distribution (sarge) this problem has been fixed in
version 1.0.1-1sarge5.
For the upcoming stable distribution (etch) this problem has been
fixed in version 1.1.2+dfsg-2.
For the unstable distribution (sid) this problem has been fixed in
version 1.1.2+dfsg-2.
We recommend that you upgrade your xine-lib packages.


Solution : http://www.debian.org/security/2006/dsa-1244
Risk factor : High';

if (description) {
 script_id(23949);
 script_version("$Revision: 1.3 $");
 script_xref(name: "DSA", value: "1244");
 script_cve_id("CVE-2006-6172");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1244] DSA-1244-1 xine-lib");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1244-1 xine-lib");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'libxine-dev', release: '3.1', reference: '1.0.1-1sarge5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libxine-dev is vulnerable in Debian 3.1.\nUpgrade to libxine-dev_1.0.1-1sarge5\n');
}
if (deb_check(prefix: 'libxine1', release: '3.1', reference: '1.0.1-1sarge5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libxine1 is vulnerable in Debian 3.1.\nUpgrade to libxine1_1.0.1-1sarge5\n');
}
if (deb_check(prefix: 'xine-lib', release: '4.0', reference: '1.1.2+dfsg-2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package xine-lib is vulnerable in Debian etch.\nUpgrade to xine-lib_1.1.2+dfsg-2\n');
}
if (deb_check(prefix: 'xine-lib', release: '3.1', reference: '1.0.1-1sarge5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package xine-lib is vulnerable in Debian sarge.\nUpgrade to xine-lib_1.0.1-1sarge5\n');
}
if (w) { security_hole(port: 0, data: desc); }
