# This script was automatically generated from the dsa-1248
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Roland Lezuo and Josselin Mouette discovered that the libsoup HTTP
library performs insufficient sanitising when parsing HTTP headers,
which might lead to denial of service.
For the stable distribution (sarge) this problem has been fixed in
version 2.2.3-2sarge1.
For the upcoming stable distribution (etch) this problem has been
fixed in version 2.2.98-2.
For the unstable distribution (sid) this problem has been fixed in
version 2.2.98-2.
We recommend that you upgrade your libsoup package.


Solution : http://www.debian.org/security/2007/dsa-1248
Risk factor : High';

if (description) {
 script_id(24025);
 script_version("$Revision: 1.3 $");
 script_xref(name: "DSA", value: "1248");
 script_cve_id("CVE-2006-5876");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1248] DSA-1248-1 libsoup");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1248-1 libsoup");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'libsoup2.2-7', release: '3.1', reference: '2.2.3-2sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libsoup2.2-7 is vulnerable in Debian 3.1.\nUpgrade to libsoup2.2-7_2.2.3-2sarge1\n');
}
if (deb_check(prefix: 'libsoup2.2-dev', release: '3.1', reference: '2.2.3-2sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libsoup2.2-dev is vulnerable in Debian 3.1.\nUpgrade to libsoup2.2-dev_2.2.3-2sarge1\n');
}
if (deb_check(prefix: 'libsoup2.2-doc', release: '3.1', reference: '2.2.3-2sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libsoup2.2-doc is vulnerable in Debian 3.1.\nUpgrade to libsoup2.2-doc_2.2.3-2sarge1\n');
}
if (deb_check(prefix: 'libsoup', release: '4.0', reference: '2.2.98-2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libsoup is vulnerable in Debian etch.\nUpgrade to libsoup_2.2.98-2\n');
}
if (deb_check(prefix: 'libsoup', release: '3.1', reference: '2.2.3-2sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libsoup is vulnerable in Debian sarge.\nUpgrade to libsoup_2.2.3-2sarge1\n');
}
if (w) { security_hole(port: 0, data: desc); }
