# This script was automatically generated from the dsa-1250
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
It was discovered that cacti, a frontend to rrdtool, performs insufficient
validation of data passed to the <q>cmd</q> script, which allows SQL
injection and the execution of arbitrary shell commands.
For the stable distribution (sarge) this problem has been fixed in
version 0.8.6c-7sarge4.
For the upcoming stable distribution (etch) this problem has been
fixed in version 0.8.6i-3.
For the unstable distribution (sid) this problem has been fixed in
version 0.8.6i-3.
We recommend that you upgrade your cacti package.


Solution : http://www.debian.org/security/2007/dsa-1250
Risk factor : High';

if (description) {
 script_id(24247);
 script_version("$Revision: 1.2 $");
 script_xref(name: "DSA", value: "1250");
 script_cve_id("CVE-2006-6799");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1250] DSA-1250-1 cacti");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1250-1 cacti");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'cacti', release: '3.1', reference: '0.8.6c-7sarge4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package cacti is vulnerable in Debian 3.1.\nUpgrade to cacti_0.8.6c-7sarge4\n');
}
if (deb_check(prefix: 'cacti', release: '4.0', reference: '0.8.6i-3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package cacti is vulnerable in Debian etch.\nUpgrade to cacti_0.8.6i-3\n');
}
if (deb_check(prefix: 'cacti', release: '3.1', reference: '0.8.6c-7sarge4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package cacti is vulnerable in Debian sarge.\nUpgrade to cacti_0.8.6c-7sarge4\n');
}
if (w) { security_hole(port: 0, data: desc); }
