# This script was automatically generated from the dsa-1253
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Several security related problems have been discovered in Mozilla and
derived products such as Mozilla Firefox.  The Common Vulnerabilities
and Exposures project identifies the following vulnerabilities:
    Several vulnerabilities in the layout engine allow remote
    attackers to cause a denial of service and possibly permit them to
    execute arbitrary code. [MFSA 2006-68]
    Several vulnerabilities in the JavaScript engine allow remote
    attackers to cause a denial of service and possibly permit them to
    execute arbitrary code. [MFSA 2006-68]
    A bug in the js_dtoa function allows remote attackers to cause a
    denial of service. [MFSA 2006-68]
    "shutdown" discovered a vulnerability that allows remote attackers
    to gain privileges and install malicious code via the watch
    JavaScript function. [MFSA 2006-70]
    Steven Michaud discovered a programming bug that allows remote
    attackers to cause a denial of service. [MFSA 2006-71]
    "moz_bug_r_a4" reported that the src attribute of an IMG element
    could be used to inject JavaScript code. [MFSA 2006-72]
For the stable distribution (sarge) these problems have been fixed in
version 1.0.4-2sarge15.
For the testing (etch) and unstable (sid) distribution these problems
have been fixed in version 2.0.0.1+dfsg-2 of iceweasel.
We recommend that you upgrade your firefox and iceweasel packages.


Solution : http://www.debian.org/security/2007/dsa-1253
Risk factor : High';

if (description) {
 script_id(24292);
 script_version("$Revision: 1.2 $");
 script_xref(name: "DSA", value: "1253");
 script_cve_id("CVE-2006-6497", "CVE-2006-6498", "CVE-2006-6499", "CVE-2006-6501", "CVE-2006-6502", "CVE-2006-6503");
 script_bugtraq_id(21668);
 script_xref(name: "CERT", value: "263412");
 script_xref(name: "CERT", value: "405092");
 script_xref(name: "CERT", value: "427972");
 script_xref(name: "CERT", value: "428500");
 script_xref(name: "CERT", value: "447772");
 script_xref(name: "CERT", value: "606260");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1253] DSA-1253-1 mozilla-firefox");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1253-1 mozilla-firefox");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'mozilla-firefox', release: '3.1', reference: '1.0.4-2sarge15')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mozilla-firefox is vulnerable in Debian 3.1.\nUpgrade to mozilla-firefox_1.0.4-2sarge15\n');
}
if (deb_check(prefix: 'mozilla-firefox-dom-inspector', release: '3.1', reference: '1.0.4-2sarge15')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mozilla-firefox-dom-inspector is vulnerable in Debian 3.1.\nUpgrade to mozilla-firefox-dom-inspector_1.0.4-2sarge15\n');
}
if (deb_check(prefix: 'mozilla-firefox-gnome-support', release: '3.1', reference: '1.0.4-2sarge15')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mozilla-firefox-gnome-support is vulnerable in Debian 3.1.\nUpgrade to mozilla-firefox-gnome-support_1.0.4-2sarge15\n');
}
if (deb_check(prefix: 'mozilla-firefox', release: '3.1', reference: '1.0.4-2sarge15')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mozilla-firefox is vulnerable in Debian sarge.\nUpgrade to mozilla-firefox_1.0.4-2sarge15\n');
}
if (w) { security_hole(port: 0, data: desc); }
