# This script was automatically generated from the dsa-1255
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Liu Qishuai discovered that the GNOME gtop library performs insufficient
sanitising when parsing the system\'s /proc table, which may lead to
the execution of arbitrary code.
For the stable distribution (sarge) this problem has been fixed in
version 2.6.0-4sarge1.
For the upcoming stable distribution (etch) this problem has been
fixed in version 2.14.4-3.
For the unstable distribution (sid) this problem has been fixed in
version 2.14.4-3.
We recommend that you upgrade your libgtop2 packages.


Solution : http://www.debian.org/security/2007/dsa-1255
Risk factor : High';

if (description) {
 script_id(24294);
 script_version("$Revision: 1.2 $");
 script_xref(name: "DSA", value: "1255");
 script_cve_id("CVE-2007-0235");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1255] DSA-1255-1 libgtop2");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1255-1 libgtop2");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'libgtop2-2', release: '3.1', reference: '2.6.0-4sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libgtop2-2 is vulnerable in Debian 3.1.\nUpgrade to libgtop2-2_2.6.0-4sarge1\n');
}
if (deb_check(prefix: 'libgtop2-daemon', release: '3.1', reference: '2.6.0-4sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libgtop2-daemon is vulnerable in Debian 3.1.\nUpgrade to libgtop2-daemon_2.6.0-4sarge1\n');
}
if (deb_check(prefix: 'libgtop2-dev', release: '3.1', reference: '2.6.0-4sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libgtop2-dev is vulnerable in Debian 3.1.\nUpgrade to libgtop2-dev_2.6.0-4sarge1\n');
}
if (deb_check(prefix: 'libgtop2', release: '4.0', reference: '2.14.4-3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libgtop2 is vulnerable in Debian etch.\nUpgrade to libgtop2_2.14.4-3\n');
}
if (deb_check(prefix: 'libgtop2', release: '3.1', reference: '2.6.0-4sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libgtop2 is vulnerable in Debian sarge.\nUpgrade to libgtop2_2.6.0-4sarge1\n');
}
if (w) { security_hole(port: 0, data: desc); }
