# This script was automatically generated from the dsa-1256
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
It was discovered that the image loading code in the GTK+ graphical user
interface library performs insufficient error handling when loading
malformed images, which may lead to denial of service.
For the stable distribution (sarge) this problem has been fixed in
version 2.6.4-3.2. This update lacks builds for the Motorola 680x0
architecture, which had build problems. Packages will be released once
this problem has been resolved.
For the upcoming stable distribution (etch) this problem has been
fixed in version 2.8.20-5.
For the unstable distribution (sid) this problem has been fixed in
version 2.8.20-5.
We recommend that you upgrade your GTK packages.


Solution : http://www.debian.org/security/2007/dsa-1256
Risk factor : High';

if (description) {
 script_id(24295);
 script_version("$Revision: 1.2 $");
 script_xref(name: "DSA", value: "1256");
 script_cve_id("CVE-2007-0010");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1256] DSA-1256-1 gtk+2.0");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1256-1 gtk+2.0");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'gtk2-engines-pixbuf', release: '3.1', reference: '2.6.4-3.2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package gtk2-engines-pixbuf is vulnerable in Debian 3.1.\nUpgrade to gtk2-engines-pixbuf_2.6.4-3.2\n');
}
if (deb_check(prefix: 'gtk2.0-examples', release: '3.1', reference: '2.6.4-3.2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package gtk2.0-examples is vulnerable in Debian 3.1.\nUpgrade to gtk2.0-examples_2.6.4-3.2\n');
}
if (deb_check(prefix: 'libgtk2.0-0', release: '3.1', reference: '2.6.4-3.2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libgtk2.0-0 is vulnerable in Debian 3.1.\nUpgrade to libgtk2.0-0_2.6.4-3.2\n');
}
if (deb_check(prefix: 'libgtk2.0-0-dbg', release: '3.1', reference: '2.6.4-3.2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libgtk2.0-0-dbg is vulnerable in Debian 3.1.\nUpgrade to libgtk2.0-0-dbg_2.6.4-3.2\n');
}
if (deb_check(prefix: 'libgtk2.0-bin', release: '3.1', reference: '2.6.4-3.2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libgtk2.0-bin is vulnerable in Debian 3.1.\nUpgrade to libgtk2.0-bin_2.6.4-3.2\n');
}
if (deb_check(prefix: 'libgtk2.0-common', release: '3.1', reference: '2.6.4-3.2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libgtk2.0-common is vulnerable in Debian 3.1.\nUpgrade to libgtk2.0-common_2.6.4-3.2\n');
}
if (deb_check(prefix: 'libgtk2.0-dev', release: '3.1', reference: '2.6.4-3.2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libgtk2.0-dev is vulnerable in Debian 3.1.\nUpgrade to libgtk2.0-dev_2.6.4-3.2\n');
}
if (deb_check(prefix: 'libgtk2.0-doc', release: '3.1', reference: '2.6.4-3.2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libgtk2.0-doc is vulnerable in Debian 3.1.\nUpgrade to libgtk2.0-doc_2.6.4-3.2\n');
}
if (deb_check(prefix: 'gtk+2.0', release: '4.0', reference: '2.8.20-5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package gtk+2.0 is vulnerable in Debian etch.\nUpgrade to gtk+2.0_2.8.20-5\n');
}
if (deb_check(prefix: 'gtk+2.0', release: '3.1', reference: '2.6.4-3.2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package gtk+2.0 is vulnerable in Debian sarge.\nUpgrade to gtk+2.0_2.6.4-3.2\n');
}
if (w) { security_hole(port: 0, data: desc); }
