# This script was automatically generated from the dsa-1261
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
It was discovered that the PostgreSQL database performs insufficient type
checking for SQL function arguments, which might lead to denial of service
or information disclosure.
For the stable distribution (sarge) this problem has been fixed in
version 7.4.7-6sarge4.
For the upcoming stable distribution (etch) this problem has been
fixed in version 8.1.7-1 of the postgresql-8.1 package.
For the unstable distribution (sid) this problem has been fixed in
version 8.1.7-1 of the postgresql-8.1 package.
We recommend that you upgrade your PostgreSQL packages.


Solution : http://www.debian.org/security/2007/dsa-1261
Risk factor : High';

if (description) {
 script_id(24359);
 script_version("$Revision: 1.2 $");
 script_xref(name: "DSA", value: "1261");
 script_cve_id("CVE-2007-0555");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1261] DSA-1261-1 postgresql");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1261-1 postgresql");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'libecpg-dev', release: '3.1', reference: '7.4.7-6sarge4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libecpg-dev is vulnerable in Debian 3.1.\nUpgrade to libecpg-dev_7.4.7-6sarge4\n');
}
if (deb_check(prefix: 'libecpg4', release: '3.1', reference: '7.4.7-6sarge4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libecpg4 is vulnerable in Debian 3.1.\nUpgrade to libecpg4_7.4.7-6sarge4\n');
}
if (deb_check(prefix: 'libpgtcl', release: '3.1', reference: '7.4.7-6sarge4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libpgtcl is vulnerable in Debian 3.1.\nUpgrade to libpgtcl_7.4.7-6sarge4\n');
}
if (deb_check(prefix: 'libpgtcl-dev', release: '3.1', reference: '7.4.7-6sarge4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libpgtcl-dev is vulnerable in Debian 3.1.\nUpgrade to libpgtcl-dev_7.4.7-6sarge4\n');
}
if (deb_check(prefix: 'libpq3', release: '3.1', reference: '7.4.7-6sarge4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libpq3 is vulnerable in Debian 3.1.\nUpgrade to libpq3_7.4.7-6sarge4\n');
}
if (deb_check(prefix: 'postgresql', release: '3.1', reference: '7.4.7-6sarge4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package postgresql is vulnerable in Debian 3.1.\nUpgrade to postgresql_7.4.7-6sarge4\n');
}
if (deb_check(prefix: 'postgresql-client', release: '3.1', reference: '7.4.7-6sarge4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package postgresql-client is vulnerable in Debian 3.1.\nUpgrade to postgresql-client_7.4.7-6sarge4\n');
}
if (deb_check(prefix: 'postgresql-contrib', release: '3.1', reference: '7.4.7-6sarge4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package postgresql-contrib is vulnerable in Debian 3.1.\nUpgrade to postgresql-contrib_7.4.7-6sarge4\n');
}
if (deb_check(prefix: 'postgresql-dev', release: '3.1', reference: '7.4.7-6sarge4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package postgresql-dev is vulnerable in Debian 3.1.\nUpgrade to postgresql-dev_7.4.7-6sarge4\n');
}
if (deb_check(prefix: 'postgresql-doc', release: '3.1', reference: '7.4.7-6sarge4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package postgresql-doc is vulnerable in Debian 3.1.\nUpgrade to postgresql-doc_7.4.7-6sarge4\n');
}
if (deb_check(prefix: 'postgresql', release: '4.0', reference: '8.1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package postgresql is vulnerable in Debian etch.\nUpgrade to postgresql_8.1\n');
}
if (deb_check(prefix: 'postgresql', release: '3.1', reference: '7.4.7-6sarge4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package postgresql is vulnerable in Debian sarge.\nUpgrade to postgresql_7.4.7-6sarge4\n');
}
if (w) { security_hole(port: 0, data: desc); }
