# This script was automatically generated from the dsa-1271
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
A design error has been identified in the OpenAFS, a cross-platform
distributed filesystem included with Debian.
OpenAFS historically has enabled setuid filesystem support for the local
cell.  However, with its existing protocol, OpenAFS can only use
encryption, and therefore integrity protection, if the user is
authenticated.  Unauthenticated access doesn\'t do integrity protection.
The practical result is that it\'s possible for an attacker with
knowledge of AFS to forge an AFS FetchStatus call and make an arbitrary
binary file appear to an AFS client host to be setuid.  If they can then
arrange for that binary to be executed, they will be able to achieve
privilege escalation.
OpenAFS 1.3.81-3sarge2 changes the default behavior to disable setuid
files globally, including the local cell.  It is important to note that
this change will not take effect until the AFS kernel module, built from
the openafs-modules-source package, is rebuilt and loaded into your
kernel.  As a temporary workaround until the kernel module can be
reloaded, setuid support can be manually disabled for the local cell by
running the following command as root
Following the application of this update, if you are certain there is
no security risk of an attacker forging AFS fileserver responses, you
can re-enable setuid status selectively with the following command,
however this should not be done on sites that are visible to the
Internet
For the stable distribution (sarge), this problem has been fixed in
version 1.3.81-3sarge2.
For the unstable distribution (sid) and the upcoming stable
distribution (etch), this problem will be fixed in version 1.4.2-6.
We recommend that you upgrade your openafs package.


Solution : http://www.debian.org/security/2007/dsa-1271
Risk factor : High';

if (description) {
 script_id(24880);
 script_version("$Revision: 1.2 $");
 script_xref(name: "DSA", value: "1271");
 script_cve_id("CVE-2007-1507");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1271] DSA-1271-1 openafs");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1271-1 openafs");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'libopenafs-dev', release: '3.1', reference: '1.3.81-3sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libopenafs-dev is vulnerable in Debian 3.1.\nUpgrade to libopenafs-dev_1.3.81-3sarge2\n');
}
if (deb_check(prefix: 'libpam-openafs-kaserver', release: '3.1', reference: '1.3.81-3sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libpam-openafs-kaserver is vulnerable in Debian 3.1.\nUpgrade to libpam-openafs-kaserver_1.3.81-3sarge2\n');
}
if (deb_check(prefix: 'openafs-client', release: '3.1', reference: '1.3.81-3sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openafs-client is vulnerable in Debian 3.1.\nUpgrade to openafs-client_1.3.81-3sarge2\n');
}
if (deb_check(prefix: 'openafs-dbserver', release: '3.1', reference: '1.3.81-3sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openafs-dbserver is vulnerable in Debian 3.1.\nUpgrade to openafs-dbserver_1.3.81-3sarge2\n');
}
if (deb_check(prefix: 'openafs-fileserver', release: '3.1', reference: '1.3.81-3sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openafs-fileserver is vulnerable in Debian 3.1.\nUpgrade to openafs-fileserver_1.3.81-3sarge2\n');
}
if (deb_check(prefix: 'openafs-kpasswd', release: '3.1', reference: '1.3.81-3sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openafs-kpasswd is vulnerable in Debian 3.1.\nUpgrade to openafs-kpasswd_1.3.81-3sarge2\n');
}
if (deb_check(prefix: 'openafs-modules-source', release: '3.1', reference: '1.3.81-3sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openafs-modules-source is vulnerable in Debian 3.1.\nUpgrade to openafs-modules-source_1.3.81-3sarge2\n');
}
if (deb_check(prefix: 'openafs', release: '3.1', reference: '1.3.81-3sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openafs is vulnerable in Debian sarge.\nUpgrade to openafs_1.3.81-3sarge2\n');
}
if (w) { security_hole(port: 0, data: desc); }
