# This script was automatically generated from the dsa-1273
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Several vulnerabilities have been discovered in nas, the Network Audio
System.
A stack-based buffer overflow in the accept_att_local function in
server/os/connection.c in nas allows remote attackers to execute
arbitrary code via a long path slave name in a USL socket connection.
An integer overflow in the ProcAuWriteElement function in
server/dia/audispatch.c allows remote attackers to cause a denial of
service (crash) and possibly execute arbitrary code via a large
max_samples value.
The AddResource function in server/dia/resource.c allows remote
attackers to cause a denial of service (server crash) via a
nonexistent client ID.
An array index error allows remote attackers to cause a denial of service
(crash) via (1) large num_action values in the ProcAuSetElements
function in server/dia/audispatch.c or (2) a large inputNum parameter
to the compileInputs function in server/dia/auutil.c.
The ReadRequestFromClient function in server/os/io.c allows remote
attackers to cause a denial of service (crash) via multiple
simultaneous connections, which triggers a NULL pointer dereference.
For the stable distribution (sarge), these problems have been fixed in
version 1.7-2sarge1.
For the upcoming stable distribution (etch) and the unstable
distribution (sid) these problems have been fixed in version 1.8-4.
We recommend that you upgrade your nas package.


Solution : http://www.debian.org/security/2007/dsa-1273
Risk factor : High';

if (description) {
 script_id(24921);
 script_version("$Revision: 1.3 $");
 script_xref(name: "DSA", value: "1273");
 script_cve_id("CVE-2007-1543", "CVE-2007-1544", "CVE-2007-1545", "CVE-2007-1546", "CVE-2007-1547");
 script_bugtraq_id(23017);

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1273] DSA-1273-1 nas");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1273-1 nas");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'libaudio-dev', release: '3.1', reference: '1.7-2sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libaudio-dev is vulnerable in Debian 3.1.\nUpgrade to libaudio-dev_1.7-2sarge1\n');
}
if (deb_check(prefix: 'libaudio2', release: '3.1', reference: '1.7-2sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libaudio2 is vulnerable in Debian 3.1.\nUpgrade to libaudio2_1.7-2sarge1\n');
}
if (deb_check(prefix: 'nas', release: '3.1', reference: '1.7-2sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package nas is vulnerable in Debian 3.1.\nUpgrade to nas_1.7-2sarge1\n');
}
if (deb_check(prefix: 'nas-bin', release: '3.1', reference: '1.7-2sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package nas-bin is vulnerable in Debian 3.1.\nUpgrade to nas-bin_1.7-2sarge1\n');
}
if (deb_check(prefix: 'nas-doc', release: '3.1', reference: '1.7-2sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package nas-doc is vulnerable in Debian 3.1.\nUpgrade to nas-doc_1.7-2sarge1\n');
}
if (deb_check(prefix: 'nas', release: '3.1', reference: '1.7-2sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package nas is vulnerable in Debian sarge.\nUpgrade to nas_1.7-2sarge1\n');
}
if (w) { security_hole(port: 0, data: desc); }
