# This script was automatically generated from the dsa-1275
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
A cross-site scripting vulnerability in zope, a web application
server, could allow an attacker to inject arbitrary HTML and/or
JavaScript into the victim\'s web browser.  This code would run within
the security context of the web browser, potentially allowing the
attacker to access private data such as authentication cookies, or to
affect the rendering or behavior of zope web pages.
For the stable distribution (sarge), this problem has been fixed in
version 2.7.5-2sarge4.
The upcoming stable distribution (etch) and the unstable distribution
(sid) include zope2.9, and this vulnerability is fixed in version
2.9.6-4etch1 for etch and 2.9.7-1 for sid.
We recommend that you upgrade your zope2.7 package.


Solution : http://www.debian.org/security/2007/dsa-1275
Risk factor : High';

if (description) {
 script_id(25009);
 script_version("$Revision: 1.2 $");
 script_xref(name: "DSA", value: "1275");
 script_cve_id("CVE-2007-0240");
 script_bugtraq_id(23084);

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1275] DSA-1275-1 zope2.7");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1275-1 zope2.7");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'zope2.7', release: '3.1', reference: '2.7.5-2sarge4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package zope2.7 is vulnerable in Debian 3.1.\nUpgrade to zope2.7_2.7.5-2sarge4\n');
}
if (deb_check(prefix: 'zope2.7', release: '3.1', reference: '2.7.5-2sarge4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package zope2.7 is vulnerable in Debian sarge.\nUpgrade to zope2.7_2.7.5-2sarge4\n');
}
if (w) { security_hole(port: 0, data: desc); }
