# This script was automatically generated from the dsa-1282
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Several remote vulnerabilities have been discovered in PHP, a
server-side, HTML-embedded scripting language, which may lead to the
execution of arbitrary code. The Common Vulnerabilities and Exposures
project identifies the following problems:
CVE-2007-1286
    Stefan Esser discovered an overflow in the object reference handling
    code of the unserialize() function, which allows the execution of
    arbitrary code if malformed input is passed from an application.
CVE-2007-1380
    Stefan Esser discovered that the session handler performs
    insufficient validation of variable name length values, which allows
    information disclosure through a heap information leak.
CVE-2007-1521
    Stefan Esser discovered a double free vulnerability in the
    session_regenerate_id() function, which allows the execution of
    arbitrary code. 
CVE-2007-1711
    Stefan Esser discovered a double free vulnerability in the session
    management code, which allows the execution of arbitrary code. 
CVE-2007-1718
    Stefan Esser discovered that the mail() function performs
    insufficient validation of folded mail headers, which allows mail
    header injection.
CVE-2007-1777
    Stefan Esser discovered that the extension to handle ZIP archives
    performs insufficient length checks, which allows the execution of
    arbitrary code.
For the oldstable distribution (sarge) these problems have been fixed in
version 4.3.10-20.
For the stable distribution (etch) these problems have been fixed
in version 4.4.4-8+etch2.
For the unstable distribution (sid) these problems have been fixed in
version 4.4.6-1. php4 will be removed from sid; thus you are strongly
advised to migrate to php5 if you prefer to follow the unstable
distribution.
We recommend that you upgrade your PHP packages. Packages for the arm,
m68k, mips and mipsel architectures are not yet available. They will be
provided later.


Solution : http://www.debian.org/security/2007/dsa-1282
Risk factor : High';

if (description) {
 script_id(25099);
 script_version("$Revision: 1.2 $");
 script_xref(name: "DSA", value: "1282");
 script_cve_id("CVE-2007-1286", "CVE-2007-1380", "CVE-2007-1521", "CVE-2007-1711", "CVE-2007-1718", "CVE-2007-1777");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1282] DSA-1282-1 php4");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1282-1 php4");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'libapache-mod-php4', release: '3.1', reference: '4.3.10-20')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libapache-mod-php4 is vulnerable in Debian 3.1.\nUpgrade to libapache-mod-php4_4.3.10-20\n');
}
if (deb_check(prefix: 'libapache2-mod-php4', release: '3.1', reference: '4.3.10-20')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libapache2-mod-php4 is vulnerable in Debian 3.1.\nUpgrade to libapache2-mod-php4_4.3.10-20\n');
}
if (deb_check(prefix: 'php4', release: '3.1', reference: '4.3.10-20')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package php4 is vulnerable in Debian 3.1.\nUpgrade to php4_4.3.10-20\n');
}
if (deb_check(prefix: 'php4-cgi', release: '3.1', reference: '4.3.10-20')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package php4-cgi is vulnerable in Debian 3.1.\nUpgrade to php4-cgi_4.3.10-20\n');
}
if (deb_check(prefix: 'php4-cli', release: '3.1', reference: '4.3.10-20')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package php4-cli is vulnerable in Debian 3.1.\nUpgrade to php4-cli_4.3.10-20\n');
}
if (deb_check(prefix: 'php4-common', release: '3.1', reference: '4.3.10-20')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package php4-common is vulnerable in Debian 3.1.\nUpgrade to php4-common_4.3.10-20\n');
}
if (deb_check(prefix: 'php4-curl', release: '3.1', reference: '4.3.10-20')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package php4-curl is vulnerable in Debian 3.1.\nUpgrade to php4-curl_4.3.10-20\n');
}
if (deb_check(prefix: 'php4-dev', release: '3.1', reference: '4.3.10-20')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package php4-dev is vulnerable in Debian 3.1.\nUpgrade to php4-dev_4.3.10-20\n');
}
if (deb_check(prefix: 'php4-domxml', release: '3.1', reference: '4.3.10-20')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package php4-domxml is vulnerable in Debian 3.1.\nUpgrade to php4-domxml_4.3.10-20\n');
}
if (deb_check(prefix: 'php4-gd', release: '3.1', reference: '4.3.10-20')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package php4-gd is vulnerable in Debian 3.1.\nUpgrade to php4-gd_4.3.10-20\n');
}
if (deb_check(prefix: 'php4-imap', release: '3.1', reference: '4.3.10-20')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package php4-imap is vulnerable in Debian 3.1.\nUpgrade to php4-imap_4.3.10-20\n');
}
if (deb_check(prefix: 'php4-ldap', release: '3.1', reference: '4.3.10-20')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package php4-ldap is vulnerable in Debian 3.1.\nUpgrade to php4-ldap_4.3.10-20\n');
}
if (deb_check(prefix: 'php4-mcal', release: '3.1', reference: '4.3.10-20')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package php4-mcal is vulnerable in Debian 3.1.\nUpgrade to php4-mcal_4.3.10-20\n');
}
if (deb_check(prefix: 'php4-mhash', release: '3.1', reference: '4.3.10-20')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package php4-mhash is vulnerable in Debian 3.1.\nUpgrade to php4-mhash_4.3.10-20\n');
}
if (deb_check(prefix: 'php4-mysql', release: '3.1', reference: '4.3.10-20')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package php4-mysql is vulnerable in Debian 3.1.\nUpgrade to php4-mysql_4.3.10-20\n');
}
if (deb_check(prefix: 'php4-odbc', release: '3.1', reference: '4.3.10-20')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package php4-odbc is vulnerable in Debian 3.1.\nUpgrade to php4-odbc_4.3.10-20\n');
}
if (deb_check(prefix: 'php4-pear', release: '3.1', reference: '4.3.10-20')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package php4-pear is vulnerable in Debian 3.1.\nUpgrade to php4-pear_4.3.10-20\n');
}
if (deb_check(prefix: 'php4-recode', release: '3.1', reference: '4.3.10-20')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package php4-recode is vulnerable in Debian 3.1.\nUpgrade to php4-recode_4.3.10-20\n');
}
if (deb_check(prefix: 'php4-snmp', release: '3.1', reference: '4.3.10-20')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package php4-snmp is vulnerable in Debian 3.1.\nUpgrade to php4-snmp_4.3.10-20\n');
}
if (deb_check(prefix: 'php4-sybase', release: '3.1', reference: '4.3.10-20')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package php4-sybase is vulnerable in Debian 3.1.\nUpgrade to php4-sybase_4.3.10-20\n');
}
if (deb_check(prefix: 'php4-xslt', release: '3.1', reference: '4.3.10-20')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package php4-xslt is vulnerable in Debian 3.1.\nUpgrade to php4-xslt_4.3.10-20\n');
}
if (deb_check(prefix: 'libapache-mod-php4', release: '4.0', reference: '4.4.4-8+etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libapache-mod-php4 is vulnerable in Debian 4.0.\nUpgrade to libapache-mod-php4_4.4.4-8+etch2\n');
}
if (deb_check(prefix: 'libapache2-mod-php4', release: '4.0', reference: '4.4.4-8+etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libapache2-mod-php4 is vulnerable in Debian 4.0.\nUpgrade to libapache2-mod-php4_4.4.4-8+etch2\n');
}
if (deb_check(prefix: 'php4', release: '4.0', reference: '4.4.4-8+etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package php4 is vulnerable in Debian 4.0.\nUpgrade to php4_4.4.4-8+etch2\n');
}
if (deb_check(prefix: 'php4-cgi', release: '4.0', reference: '4.4.4-8+etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package php4-cgi is vulnerable in Debian 4.0.\nUpgrade to php4-cgi_4.4.4-8+etch2\n');
}
if (deb_check(prefix: 'php4-cli', release: '4.0', reference: '4.4.4-8+etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package php4-cli is vulnerable in Debian 4.0.\nUpgrade to php4-cli_4.4.4-8+etch2\n');
}
if (deb_check(prefix: 'php4-common', release: '4.0', reference: '4.4.4-8+etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package php4-common is vulnerable in Debian 4.0.\nUpgrade to php4-common_4.4.4-8+etch2\n');
}
if (deb_check(prefix: 'php4-curl', release: '4.0', reference: '4.4.4-8+etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package php4-curl is vulnerable in Debian 4.0.\nUpgrade to php4-curl_4.4.4-8+etch2\n');
}
if (deb_check(prefix: 'php4-dev', release: '4.0', reference: '4.4.4-8+etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package php4-dev is vulnerable in Debian 4.0.\nUpgrade to php4-dev_4.4.4-8+etch2\n');
}
if (deb_check(prefix: 'php4-domxml', release: '4.0', reference: '4.4.4-8+etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package php4-domxml is vulnerable in Debian 4.0.\nUpgrade to php4-domxml_4.4.4-8+etch2\n');
}
if (deb_check(prefix: 'php4-gd', release: '4.0', reference: '4.4.4-8+etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package php4-gd is vulnerable in Debian 4.0.\nUpgrade to php4-gd_4.4.4-8+etch2\n');
}
if (deb_check(prefix: 'php4-imap', release: '4.0', reference: '4.4.4-8+etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package php4-imap is vulnerable in Debian 4.0.\nUpgrade to php4-imap_4.4.4-8+etch2\n');
}
if (deb_check(prefix: 'php4-interbase', release: '4.0', reference: '4.4.4-8+etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package php4-interbase is vulnerable in Debian 4.0.\nUpgrade to php4-interbase_4.4.4-8+etch2\n');
}
if (deb_check(prefix: 'php4-ldap', release: '4.0', reference: '4.4.4-8+etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package php4-ldap is vulnerable in Debian 4.0.\nUpgrade to php4-ldap_4.4.4-8+etch2\n');
}
if (deb_check(prefix: 'php4-mcal', release: '4.0', reference: '4.4.4-8+etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package php4-mcal is vulnerable in Debian 4.0.\nUpgrade to php4-mcal_4.4.4-8+etch2\n');
}
if (deb_check(prefix: 'php4-mcrypt', release: '4.0', reference: '4.4.4-8+etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package php4-mcrypt is vulnerable in Debian 4.0.\nUpgrade to php4-mcrypt_4.4.4-8+etch2\n');
}
if (deb_check(prefix: 'php4-mhash', release: '4.0', reference: '4.4.4-8+etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package php4-mhash is vulnerable in Debian 4.0.\nUpgrade to php4-mhash_4.4.4-8+etch2\n');
}
if (deb_check(prefix: 'php4-mysql', release: '4.0', reference: '4.4.4-8+etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package php4-mysql is vulnerable in Debian 4.0.\nUpgrade to php4-mysql_4.4.4-8+etch2\n');
}
if (deb_check(prefix: 'php4-odbc', release: '4.0', reference: '4.4.4-8+etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package php4-odbc is vulnerable in Debian 4.0.\nUpgrade to php4-odbc_4.4.4-8+etch2\n');
}
if (deb_check(prefix: 'php4-pear', release: '4.0', reference: '4.4.4-8+etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package php4-pear is vulnerable in Debian 4.0.\nUpgrade to php4-pear_4.4.4-8+etch2\n');
}
if (deb_check(prefix: 'php4-pgsql', release: '4.0', reference: '4.4.4-8+etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package php4-pgsql is vulnerable in Debian 4.0.\nUpgrade to php4-pgsql_4.4.4-8+etch2\n');
}
if (deb_check(prefix: 'php4-pspell', release: '4.0', reference: '4.4.4-8+etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package php4-pspell is vulnerable in Debian 4.0.\nUpgrade to php4-pspell_4.4.4-8+etch2\n');
}
if (deb_check(prefix: 'php4-recode', release: '4.0', reference: '4.4.4-8+etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package php4-recode is vulnerable in Debian 4.0.\nUpgrade to php4-recode_4.4.4-8+etch2\n');
}
if (deb_check(prefix: 'php4-snmp', release: '4.0', reference: '4.4.4-8+etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package php4-snmp is vulnerable in Debian 4.0.\nUpgrade to php4-snmp_4.4.4-8+etch2\n');
}
if (deb_check(prefix: 'php4-sybase', release: '4.0', reference: '4.4.4-8+etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package php4-sybase is vulnerable in Debian 4.0.\nUpgrade to php4-sybase_4.4.4-8+etch2\n');
}
if (deb_check(prefix: 'php4-xslt', release: '4.0', reference: '4.4.4-8+etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package php4-xslt is vulnerable in Debian 4.0.\nUpgrade to php4-xslt_4.4.4-8+etch2\n');
}
if (deb_check(prefix: 'php4', release: '4.0', reference: '4.4.4-8+etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package php4 is vulnerable in Debian etch.\nUpgrade to php4_4.4.4-8+etch2\n');
}
if (deb_check(prefix: 'php4', release: '3.1', reference: '4.3.10-20')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package php4 is vulnerable in Debian sarge.\nUpgrade to php4_4.3.10-20\n');
}
if (w) { security_hole(port: 0, data: desc); }
