# This script was automatically generated from the dsa-1284
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Several vulnerabilities have been discovered in the QEMU processor
emulator, which may lead to the execution of arbitrary code or denial of
service. The Common Vulnerabilities and Exposures project identifies the
following problems:
    Tavis Ormandy discovered that a memory management routine of the Cirrus
    video driver performs insufficient bounds checking, which might
    allow the execution of arbitrary code through a heap overflow.
    Tavis Ormandy discovered that the NE2000 network driver and the socket
    code perform insufficient input validation, which might allow the
    execution of arbitrary code through a heap overflow.
    Tavis Ormandy discovered that the <q>icebp</q> instruction can be abused to
    terminate the emulation, resulting in denial of service.
    Tavis Ormandy discovered that the NE2000 network driver and the socket
    code perform insufficient input validation, which might allow the
    execution of arbitrary code through a heap overflow.
    Tavis Ormandy discovered that the <q>aam</q> instruction can be abused to
    crash qemu through a division by zero, resulting in denial of
    service.
For the oldstable distribution (sarge) these problems have been fixed in
version 0.6.1+20050407-1sarge1.
For the stable distribution (etch) these problems have been fixed
in version 0.8.2-4etch1.
For the unstable distribution (sid) these problems will be fixed soon.
We recommend that you upgrade your qemu packages.


Solution : http://www.debian.org/security/2007/dsa-1284
Risk factor : High';

if (description) {
 script_id(25151);
 script_version("$Revision: 1.2 $");
 script_xref(name: "DSA", value: "1284");
 script_cve_id("CVE-2007-1320");
 script_cve_id("CVE-2007-1321");
 script_cve_id("CVE-2007-1322");
 script_cve_id("CVE-2007-1366");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1284] DSA-1284-1 qemu");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1284-1 qemu");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'qemu', release: '3.1', reference: '0.6.1+20050407-1sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package qemu is vulnerable in Debian 3.1.\nUpgrade to qemu_0.6.1+20050407-1sarge1\n');
}
if (deb_check(prefix: 'qemu', release: '4.0', reference: '0.8.2-4etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package qemu is vulnerable in Debian 4.0.\nUpgrade to qemu_0.8.2-4etch1\n');
}
if (deb_check(prefix: 'qemu', release: '4.0', reference: '0.8.2-4etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package qemu is vulnerable in Debian etch.\nUpgrade to qemu_0.8.2-4etch1\n');
}
if (deb_check(prefix: 'qemu', release: '3.1', reference: '0.6.1+20050407-1sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package qemu is vulnerable in Debian sarge.\nUpgrade to qemu_0.6.1+20050407-1sarge1\n');
}
if (w) { security_hole(port: 0, data: desc); }
