# This script was automatically generated from the dsa-1287
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Two vulnerabilities have been identified in the version of
ldap-account-manager shipped with Debian 3.1 (sarge).
    An untrusted PATH vulnerability could allow a local attacker to execute
    arbitrary code with elevated privileges by providing a malicious rm
    executable and specifying a PATH environment variable referencing this
    executable.
    Improper escaping of HTML content could allow an attacker to execute a
    cross-site scripting attack (XSS) and execute arbitrary code in the
    victim\'s browser in the security context of the affected web site.
For the old stable distribution (sarge), this problem has been fixed in
version 0.4.9-2sarge1.  Newer versions of Debian (etch, lenny, and sid),
are not affected.
We recommend that you upgrade your ldap-account-manager package.


Solution : http://www.debian.org/security/2007/dsa-1287
Risk factor : High';

if (description) {
 script_id(25176);
 script_version("$Revision: 1.1 $");
 script_xref(name: "DSA", value: "1287");
 script_cve_id("CVE-2006-7191", "CVE-2007-1840");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1287] DSA-1287-1 ldap-account-manager");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1287-1 ldap-account-manager");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'ldap-account-manager', release: '3.1', reference: '0.4.9-2sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ldap-account-manager is vulnerable in Debian 3.1.\nUpgrade to ldap-account-manager_0.4.9-2sarge1\n');
}
if (deb_check(prefix: 'ldap-account-manager', release: '3.1', reference: '0.4.9-2sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ldap-account-manager is vulnerable in Debian sarge.\nUpgrade to ldap-account-manager_0.4.9-2sarge1\n');
}
if (w) { security_hole(port: 0, data: desc); }
