# This script was automatically generated from the dsa-1297
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Bernhard R. Link discovered that the CVS browsing interface of Gforge, a
collaborative development tool, performs insufficient escaping of URLs,
which allows the execution of arbitrary shell commands with the privileges
of the www-data user.
The oldstable distribution (sarge) is not affected by this problem.
For the stable distribution (etch) this problem has been fixed in
version 4.5.14-5.
For the unstable distribution (sid) this problem has been fixed in
version 4.5.14-6.
We recommend that you upgrade your gforge-plugin-scmcvs package.


Solution : http://www.debian.org/security/2007/dsa-1297
Risk factor : High';

if (description) {
 script_id(25301);
 script_version("$Revision: 1.2 $");
 script_xref(name: "DSA", value: "1297");
 script_cve_id("CVE-2007-0246");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1297] DSA-1297-1 gforge-plugin-scmcvs");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1297-1 gforge-plugin-scmcvs");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'gforge-plugin-scmcvs', release: '4.0', reference: '4.5.14-5etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package gforge-plugin-scmcvs is vulnerable in Debian 4.0.\nUpgrade to gforge-plugin-scmcvs_4.5.14-5etch1\n');
}
if (deb_check(prefix: 'gforge-plugin-scmcvs', release: '4.0', reference: '4.5.14-5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package gforge-plugin-scmcvs is vulnerable in Debian etch.\nUpgrade to gforge-plugin-scmcvs_4.5.14-5\n');
}
if (w) { security_hole(port: 0, data: desc); }
