# This script was automatically generated from the dsa-1300
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Several remote vulnerabilities have been discovered in the Iceape internet
suite, an unbranded version of the Seamonkey Internet Suite. The Common
Vulnerabilities and Exposures project identifies the following problems:
    Nicolas Derouet discovered that Iceape performs insufficient 
    validation of cookies, which could lead to denial of service.
    Gatan Leurent discovered a cryptographical weakness in APOP
    authentication, which reduces the required efforts for an MITM attack
    to intercept a password. The update enforces stricter validation, which
    prevents this attack.
    Boris Zbarsky, Eli Friedman, Georgi Guninski, Jesse Ruderman, Martijn
    Wargers and Olli Pettay discovered crashes in the layout engine, which
    might allow the execution of arbitrary code.
    Brendan Eich, Igor Bukanov, Jesse Ruderman, <q>moz_bug_r_a4</q> and Wladimir Palant
    discovered crashes in the javascript engine, which might allow the execution of
    arbitrary code.
    <q>moz_bug_r_a4</q> discovered that adding an event listener through the
     addEventListener() function allows cross-site scripting.
    Chris Thomas discovered that XUL popups can be abused for spoofing or
    phishing attacks.
Fixes for the oldstable distribution (sarge) are not available. While there
will be another round of security updates for Mozilla products, Debian doesn\'t
have the resources to backport further security fixes to the old Mozilla
products. You\'re strongly encouraged to upgrade to stable as soon as possible.
For the stable distribution (etch) these problems have been fixed in version
1.0.9-0etch1. A build for the arm architecture is not yet available, it will
be provided later.
The unstable distribution (sid) will be fixed soon.
We recommend that you upgrade your iceape packages.


Solution : http://www.debian.org/security/2007/dsa-1300
Risk factor : High';

if (description) {
 script_id(25463);
 script_version("$Revision: 1.4 $");
 script_xref(name: "DSA", value: "1300");
 script_cve_id("CVE-2007-1362", "CVE-2007-1558", "CVE-2007-2867", "CVE-2007-2868", "CVE-2007-2870", "CVE-2007-2871");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1300] DSA-1300-1 iceape");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1300-1 iceape");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'iceape', release: '4.0', reference: '1.0.9-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package iceape is vulnerable in Debian 4.0.\nUpgrade to iceape_1.0.9-0etch1\n');
}
if (deb_check(prefix: 'iceape-browser', release: '4.0', reference: '1.0.9-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package iceape-browser is vulnerable in Debian 4.0.\nUpgrade to iceape-browser_1.0.9-0etch1\n');
}
if (deb_check(prefix: 'iceape-calendar', release: '4.0', reference: '1.0.9-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package iceape-calendar is vulnerable in Debian 4.0.\nUpgrade to iceape-calendar_1.0.9-0etch1\n');
}
if (deb_check(prefix: 'iceape-chatzilla', release: '4.0', reference: '1.0.9-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package iceape-chatzilla is vulnerable in Debian 4.0.\nUpgrade to iceape-chatzilla_1.0.9-0etch1\n');
}
if (deb_check(prefix: 'iceape-dbg', release: '4.0', reference: '1.0.9-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package iceape-dbg is vulnerable in Debian 4.0.\nUpgrade to iceape-dbg_1.0.9-0etch1\n');
}
if (deb_check(prefix: 'iceape-dev', release: '4.0', reference: '1.0.9-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package iceape-dev is vulnerable in Debian 4.0.\nUpgrade to iceape-dev_1.0.9-0etch1\n');
}
if (deb_check(prefix: 'iceape-dom-inspector', release: '4.0', reference: '1.0.9-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package iceape-dom-inspector is vulnerable in Debian 4.0.\nUpgrade to iceape-dom-inspector_1.0.9-0etch1\n');
}
if (deb_check(prefix: 'iceape-gnome-support', release: '4.0', reference: '1.0.9-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package iceape-gnome-support is vulnerable in Debian 4.0.\nUpgrade to iceape-gnome-support_1.0.9-0etch1\n');
}
if (deb_check(prefix: 'iceape-mailnews', release: '4.0', reference: '1.0.9-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package iceape-mailnews is vulnerable in Debian 4.0.\nUpgrade to iceape-mailnews_1.0.9-0etch1\n');
}
if (deb_check(prefix: 'mozilla', release: '4.0', reference: '1.8+1.0.9-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mozilla is vulnerable in Debian 4.0.\nUpgrade to mozilla_1.8+1.0.9-0etch1\n');
}
if (deb_check(prefix: 'mozilla-browser', release: '4.0', reference: '1.8+1.0.9-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mozilla-browser is vulnerable in Debian 4.0.\nUpgrade to mozilla-browser_1.8+1.0.9-0etch1\n');
}
if (deb_check(prefix: 'mozilla-calendar', release: '4.0', reference: '1.8+1.0.9-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mozilla-calendar is vulnerable in Debian 4.0.\nUpgrade to mozilla-calendar_1.8+1.0.9-0etch1\n');
}
if (deb_check(prefix: 'mozilla-chatzilla', release: '4.0', reference: '1.8+1.0.9-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mozilla-chatzilla is vulnerable in Debian 4.0.\nUpgrade to mozilla-chatzilla_1.8+1.0.9-0etch1\n');
}
if (deb_check(prefix: 'mozilla-dev', release: '4.0', reference: '1.8+1.0.9-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mozilla-dev is vulnerable in Debian 4.0.\nUpgrade to mozilla-dev_1.8+1.0.9-0etch1\n');
}
if (deb_check(prefix: 'mozilla-dom-inspector', release: '4.0', reference: '1.8+1.0.9-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mozilla-dom-inspector is vulnerable in Debian 4.0.\nUpgrade to mozilla-dom-inspector_1.8+1.0.9-0etch1\n');
}
if (deb_check(prefix: 'mozilla-js-debugger', release: '4.0', reference: '1.8+1.0.9-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mozilla-js-debugger is vulnerable in Debian 4.0.\nUpgrade to mozilla-js-debugger_1.8+1.0.9-0etch1\n');
}
if (deb_check(prefix: 'mozilla-mailnews', release: '4.0', reference: '1.8+1.0.9-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mozilla-mailnews is vulnerable in Debian 4.0.\nUpgrade to mozilla-mailnews_1.8+1.0.9-0etch1\n');
}
if (deb_check(prefix: 'mozilla-psm', release: '4.0', reference: '1.8+1.0.9-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mozilla-psm is vulnerable in Debian 4.0.\nUpgrade to mozilla-psm_1.8+1.0.9-0etch1\n');
}
if (deb_check(prefix: 'iceape', release: '4.0', reference: '1.0.9-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package iceape is vulnerable in Debian etch.\nUpgrade to iceape_1.0.9-0etch1\n');
}
if (w) { security_hole(port: 0, data: desc); }
