# This script was automatically generated from the dsa-1306
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Several remote vulnerabilities have been discovered in Xulrunner, a
runtime environment for XUL applications. The Common Vulnerabilities
and Exposures project identifies the following problems:
    Nicolas Derouet discovered that Xulrunner performs insufficient
    validation of cookies, which could lead to denial of service.
    Boris Zbarsky, Eli Friedman, Georgi Guninski, Jesse Ruderman, Martijn
    Wargers and Olli Pettay discovered crashes in the layout engine, which
    might allow the execution of arbitrary code.
    Brendan Eich, Igor Bukanov, Jesse Ruderman, <q>moz_bug_r_a4</q> and Wladimir
    Palant discovered crashes in the Javascript engine, which might allow
    the execution of arbitrary code.
    <q>Marcel</q> discovered that malicous web sites can cause massive
    resource consumption through the auto completion feature, resulting
    in denial of service.
    <q>moz_bug_r_a4</q> discovered that adding an event listener through the
     addEventListener() function allows cross-site scripting.
     Chris Thomas discovered that XUL popups can be abused for spoofing
     or phishing attacks.
The oldstable distribution (sarge) doesn\'t include xulrunner.
For the stable distribution (etch) these problems have been fixed in
version 1.8.0.12-0etch1.
The unstable distribution (sid) will be fixed soon.
We recommend that you upgrade your xulrunner packages.


Solution : http://www.debian.org/security/2007/dsa-1306
Risk factor : High';

if (description) {
 script_id(25505);
 script_version("$Revision: 1.4 $");
 script_xref(name: "DSA", value: "1306");
 script_cve_id("CVE-2007-1362", "CVE-2007-2867", "CVE-2007-2868", "CVE-2007-2869", "CVE-2007-2870", "CVE-2007-2871");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1306] DSA-1306-1 xulrunner");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1306-1 xulrunner");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'libmozillainterfaces-java', release: '4.0', reference: '1.8.0.12-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libmozillainterfaces-java is vulnerable in Debian 4.0.\nUpgrade to libmozillainterfaces-java_1.8.0.12-0etch1\n');
}
if (deb_check(prefix: 'libmozjs-dev', release: '4.0', reference: '1.8.0.12-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libmozjs-dev is vulnerable in Debian 4.0.\nUpgrade to libmozjs-dev_1.8.0.12-0etch1\n');
}
if (deb_check(prefix: 'libmozjs0d', release: '4.0', reference: '1.8.0.12-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libmozjs0d is vulnerable in Debian 4.0.\nUpgrade to libmozjs0d_1.8.0.12-0etch1\n');
}
if (deb_check(prefix: 'libmozjs0d-dbg', release: '4.0', reference: '1.8.0.12-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libmozjs0d-dbg is vulnerable in Debian 4.0.\nUpgrade to libmozjs0d-dbg_1.8.0.12-0etch1\n');
}
if (deb_check(prefix: 'libnspr4-0d', release: '4.0', reference: '1.8.0.12-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libnspr4-0d is vulnerable in Debian 4.0.\nUpgrade to libnspr4-0d_1.8.0.12-0etch1\n');
}
if (deb_check(prefix: 'libnspr4-0d-dbg', release: '4.0', reference: '1.8.0.12-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libnspr4-0d-dbg is vulnerable in Debian 4.0.\nUpgrade to libnspr4-0d-dbg_1.8.0.12-0etch1\n');
}
if (deb_check(prefix: 'libnspr4-dev', release: '4.0', reference: '1.8.0.12-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libnspr4-dev is vulnerable in Debian 4.0.\nUpgrade to libnspr4-dev_1.8.0.12-0etch1\n');
}
if (deb_check(prefix: 'libnss3-0d', release: '4.0', reference: '1.8.0.12-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libnss3-0d is vulnerable in Debian 4.0.\nUpgrade to libnss3-0d_1.8.0.12-0etch1\n');
}
if (deb_check(prefix: 'libnss3-0d-dbg', release: '4.0', reference: '1.8.0.12-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libnss3-0d-dbg is vulnerable in Debian 4.0.\nUpgrade to libnss3-0d-dbg_1.8.0.12-0etch1\n');
}
if (deb_check(prefix: 'libnss3-dev', release: '4.0', reference: '1.8.0.12-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libnss3-dev is vulnerable in Debian 4.0.\nUpgrade to libnss3-dev_1.8.0.12-0etch1\n');
}
if (deb_check(prefix: 'libnss3-tools', release: '4.0', reference: '1.8.0.12-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libnss3-tools is vulnerable in Debian 4.0.\nUpgrade to libnss3-tools_1.8.0.12-0etch1\n');
}
if (deb_check(prefix: 'libsmjs-dev', release: '4.0', reference: '1.8.0.12-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libsmjs-dev is vulnerable in Debian 4.0.\nUpgrade to libsmjs-dev_1.8.0.12-0etch1\n');
}
if (deb_check(prefix: 'libsmjs1', release: '4.0', reference: '1.8.0.12-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libsmjs1 is vulnerable in Debian 4.0.\nUpgrade to libsmjs1_1.8.0.12-0etch1\n');
}
if (deb_check(prefix: 'libxul-common', release: '4.0', reference: '1.8.0.12-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libxul-common is vulnerable in Debian 4.0.\nUpgrade to libxul-common_1.8.0.12-0etch1\n');
}
if (deb_check(prefix: 'libxul-dev', release: '4.0', reference: '1.8.0.12-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libxul-dev is vulnerable in Debian 4.0.\nUpgrade to libxul-dev_1.8.0.12-0etch1\n');
}
if (deb_check(prefix: 'libxul0d', release: '4.0', reference: '1.8.0.12-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libxul0d is vulnerable in Debian 4.0.\nUpgrade to libxul0d_1.8.0.12-0etch1\n');
}
if (deb_check(prefix: 'libxul0d-dbg', release: '4.0', reference: '1.8.0.12-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libxul0d-dbg is vulnerable in Debian 4.0.\nUpgrade to libxul0d-dbg_1.8.0.12-0etch1\n');
}
if (deb_check(prefix: 'python-xpcom', release: '4.0', reference: '1.8.0.12-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package python-xpcom is vulnerable in Debian 4.0.\nUpgrade to python-xpcom_1.8.0.12-0etch1\n');
}
if (deb_check(prefix: 'spidermonkey-bin', release: '4.0', reference: '1.8.0.12-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package spidermonkey-bin is vulnerable in Debian 4.0.\nUpgrade to spidermonkey-bin_1.8.0.12-0etch1\n');
}
if (deb_check(prefix: 'xulrunner', release: '4.0', reference: '1.8.0.12-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package xulrunner is vulnerable in Debian 4.0.\nUpgrade to xulrunner_1.8.0.12-0etch1\n');
}
if (deb_check(prefix: 'xulrunner-gnome-support', release: '4.0', reference: '1.8.0.12-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package xulrunner-gnome-support is vulnerable in Debian 4.0.\nUpgrade to xulrunner-gnome-support_1.8.0.12-0etch1\n');
}
if (deb_check(prefix: 'xulrunner', release: '4.0', reference: '1.8.0.12-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package xulrunner is vulnerable in Debian etch.\nUpgrade to xulrunner_1.8.0.12-0etch1\n');
}
if (w) { security_hole(port: 0, data: desc); }
